package ru.tinkoff.acquiring.sdk.ui.customview.status

import android.animation.Animator
import android.animation.AnimatorListenerAdapter
import android.animation.ValueAnimator
import android.content.Context
import android.util.AttributeSet
import android.widget.FrameLayout

/**
 * @author s.y.biryukov
 */
class StatusViewFlipper @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null
) : FrameLayout(context, attrs) {

    private var currentData: StatusViewData? = null
    private var currentView: StatusView? = null

    fun showNotification(data: StatusViewData) {
        if (currentData == data) return

        val prevView = currentView
        val newView = StatusView(context)
        currentView = newView
        currentData = data
        newView.fill(data)
        addView(newView, LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT))
        prevView?.let { oldView ->
            startViewChangeAnimation(newView, oldView)
        }
    }

    private fun startViewChangeAnimation(
        newView: StatusView,
        oldView: StatusView
    ) {
        val newHeight = measureNewViewHeight(newView)
        ValueAnimator.ofFloat(0f, 1f)
            .apply {
                addUpdateListener {
                    updateAlpha(animatedValue as Float, oldView, newView)
                    updateContainerHeight(animatedFraction, oldView.height, newHeight)
                }
                addListener(object : AnimatorListenerAdapter() {
                    override fun onAnimationEnd(animation: Animator) {
                        removeView(oldView)
                        removeListener(this)
                        removeAllUpdateListeners()
                    }
                })
            }
            .start()
    }

    private fun updateContainerHeight(
        animatedFraction: Float,
        oldHeight: Int,
        newHeight: Int
    ) {
        layoutParams.height =
            oldHeight + ((newHeight - oldHeight) * animatedFraction).toInt()
        requestLayout()
    }

    private fun updateAlpha(
        alpha: Float,
        oldView: StatusView,
        newView: StatusView
    ) {
        oldView.alpha = 1 - alpha
        newView.alpha = alpha
    }

    private fun measureNewViewHeight(newView: StatusView): Int {
        newView.measure(
            MeasureSpec.makeMeasureSpec(width, MeasureSpec.EXACTLY),
            MeasureSpec.makeMeasureSpec(height, MeasureSpec.UNSPECIFIED)
        )
        val newHeight = newView.measuredHeight
        return newHeight
    }

}
