package ru.tinkoff.acquiring.sdk.utils

import android.content.Context
import ru.tinkoff.acquiring.sdk.redesign.payment.ui.Notification
import ru.tinkoff.acquiring.sdk.ui.customview.status.StatusViewData

/**
 * @author s.y.biryukov
 */
fun Notification.toStatusViewData(context: Context): StatusViewData {
    return StatusViewData(
        type = this.type,
        title = context.getString(this.title),
        description = context.getString(this.description),
        buttonText = context.getString(this.button),
        amount = getAmountStringOnlyForSuccessNotification(),
        onButtonClick = this.onButtonClick,
        onCloseByUser = this.onCloseByUser
    )
}

private fun Notification.getAmountStringOnlyForSuccessNotification(): String? =
    if (this.type == StatusViewData.Type.SUCCESS) {
        this.amount?.let { "–${it.toHumanReadableString()}" }
    } else {
        null
    }
