/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import javax.annotation.Nonnull;
import ru.tinkoff.kora.cache.caffeine.CaffeineCacheConfig;

public final class CaffeineCacheFactory {
    @Nonnull
    public <K, V> Cache<K, V> build(@Nonnull CaffeineCacheConfig.NamedCacheConfig config) {
        Caffeine builder = Caffeine.newBuilder();
        if (config.expireAfterWrite() != null) {
            builder.expireAfterWrite(config.expireAfterWrite());
        }
        if (config.expireAfterAccess() != null) {
            builder.expireAfterAccess(config.expireAfterAccess());
        }
        if (config.initialSize() != null) {
            builder.initialCapacity(config.initialSize().intValue());
        }
        if (config.maximumSize() != null) {
            builder.maximumSize(config.maximumSize().longValue());
        }
        return builder.recordStats(StatsCounter::disabledStatsCounter).build();
    }
}

