/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.caffeine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.cache.Cache;
import ru.tinkoff.kora.cache.CacheManager;
import ru.tinkoff.kora.cache.caffeine.CaffeineCache;
import ru.tinkoff.kora.cache.caffeine.CaffeineCacheConfig;
import ru.tinkoff.kora.cache.caffeine.CaffeineCacheFactory;
import ru.tinkoff.kora.cache.telemetry.CacheTelemetry;

public final class CaffeineCacheManager<K, V>
implements CacheManager<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(CaffeineCacheManager.class);
    private final CaffeineCacheFactory factory;
    private final CaffeineCacheConfig config;
    private final CacheTelemetry telemetry;
    private final Map<String, Cache<K, V>> cacheMap = new ConcurrentHashMap<String, Cache<K, V>>();

    CaffeineCacheManager(CaffeineCacheFactory factory, CaffeineCacheConfig config, CacheTelemetry telemetry) {
        this.factory = factory;
        this.config = config;
        this.telemetry = telemetry;
    }

    @Nonnull
    public Cache<K, V> getCache(@Nonnull String name) {
        return this.cacheMap.computeIfAbsent(name, k -> {
            logger.trace("Build cache for name: {}", (Object)name);
            CaffeineCacheConfig.NamedCacheConfig namedConfig = this.config.getByName(name);
            return new CaffeineCache(name, this.factory.build(namedConfig), this.telemetry);
        });
    }
}

