/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.caffeine;

import java.time.Duration;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public record CaffeineCacheConfig(@Nullable Map<String, NamedCacheConfig> caffeine) {
    private static final String DEFAULT = "default";
    private static final NamedCacheConfig DEFAULT_CONFIG = new NamedCacheConfig(null, null, 100000L, null);

    @Nonnull
    public NamedCacheConfig getByName(@Nonnull String name) {
        if (this.caffeine == null) {
            return DEFAULT_CONFIG;
        }
        NamedCacheConfig defaultConfig = this.caffeine.getOrDefault(DEFAULT, DEFAULT_CONFIG);
        NamedCacheConfig namedConfig = this.caffeine.get(name);
        if (namedConfig == null) {
            return defaultConfig;
        }
        return new NamedCacheConfig(namedConfig.expireAfterWrite == null ? defaultConfig.expireAfterWrite : namedConfig.expireAfterWrite, namedConfig.expireAfterAccess == null ? defaultConfig.expireAfterAccess : namedConfig.expireAfterAccess, namedConfig.maximumSize == null ? defaultConfig.maximumSize : namedConfig.maximumSize, namedConfig.initialSize == null ? defaultConfig.initialSize : namedConfig.initialSize);
    }

    public record NamedCacheConfig(@Nullable Duration expireAfterWrite, @Nullable Duration expireAfterAccess, @Nullable Long maximumSize, @Nullable Integer initialSize) {
    }
}

