/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.caffeine;

import java.time.Duration;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface CaffeineCacheConfig {
    public static final String DEFAULT = "default";
    public static final NamedCacheConfig DEFAULT_CONFIG = new NamedCacheConfig(null, null, 100000L, null);

    default public Map<String, NamedCacheConfig> caffeine() {
        return Map.of();
    }

    @Nonnull
    default public NamedCacheConfig getByName(@Nonnull String name) {
        NamedCacheConfig defaultConfig = this.caffeine().getOrDefault(DEFAULT, DEFAULT_CONFIG);
        NamedCacheConfig namedConfig = this.caffeine().get(name);
        if (namedConfig == null) {
            return defaultConfig;
        }
        return new NamedCacheConfig(namedConfig.expireAfterWrite == null ? defaultConfig.expireAfterWrite : namedConfig.expireAfterWrite, namedConfig.expireAfterAccess == null ? defaultConfig.expireAfterAccess : namedConfig.expireAfterAccess, namedConfig.maximumSize == null ? defaultConfig.maximumSize : namedConfig.maximumSize, namedConfig.initialSize == null ? defaultConfig.initialSize : namedConfig.initialSize);
    }

    public record NamedCacheConfig(@Nullable Duration expireAfterWrite, @Nullable Duration expireAfterAccess, @Nullable Long maximumSize, @Nullable Integer initialSize) {
    }
}

