/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.caffeine;

import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import ru.tinkoff.kora.cache.Cache;
import ru.tinkoff.kora.cache.telemetry.CacheTelemetry;

final class CaffeineCache<K, V>
implements Cache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(CaffeineCache.class);
    private final String name;
    private final com.github.benmanes.caffeine.cache.Cache<K, V> caffeine;
    private final CacheTelemetry telemetry;

    CaffeineCache(String name, com.github.benmanes.caffeine.cache.Cache<K, V> caffeine, CacheTelemetry telemetry) {
        this.name = name;
        this.caffeine = caffeine;
        this.telemetry = telemetry;
    }

    @Nonnull
    String origin() {
        return "caffeine";
    }

    public V get(@Nonnull K key) {
        logger.trace("Cache '{}' looking for value for key: {}", (Object)this.name, key);
        CacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create(CacheTelemetry.Operation.Type.GET, this.name, this.origin());
        telemetryContext.startRecording();
        Object v = this.caffeine.getIfPresent(key);
        if (v == null) {
            logger.trace("Cache '{}' no value found for key: {}", (Object)this.name, key);
        } else {
            logger.debug("Cache '{}' found value for key: {}", (Object)this.name, key);
        }
        telemetryContext.recordSuccess(v);
        return (V)v;
    }

    @Nonnull
    public V put(@Nonnull K key, @Nonnull V value) {
        logger.trace("Cache '{}' storing for key: {}", (Object)this.name, key);
        CacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create(CacheTelemetry.Operation.Type.PUT, this.name, this.origin());
        telemetryContext.startRecording();
        this.caffeine.put(key, value);
        telemetryContext.recordSuccess();
        return value;
    }

    public void invalidate(@Nonnull K key) {
        logger.trace("Cache '{}' invalidating for key: {}", (Object)this.name, key);
        CacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create(CacheTelemetry.Operation.Type.INVALIDATE, this.name, this.origin());
        telemetryContext.startRecording();
        this.caffeine.invalidate(key);
        telemetryContext.recordSuccess();
    }

    public void invalidateAll() {
        logger.trace("Cache '{}' invalidating all values", (Object)this.name);
        CacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create(CacheTelemetry.Operation.Type.INVALIDATE_ALL, this.name, this.origin());
        telemetryContext.startRecording();
        this.caffeine.invalidateAll();
        telemetryContext.recordSuccess();
    }

    @Nonnull
    public Mono<V> getAsync(@Nonnull K key) {
        return Mono.fromCallable(() -> this.get(key));
    }

    @Nonnull
    public Mono<V> putAsync(@Nonnull K key, @Nonnull V value) {
        return Mono.fromCallable(() -> this.put(key, value));
    }

    @Nonnull
    public Mono<Void> invalidateAsync(@Nonnull K key) {
        return Mono.fromRunnable(() -> this.invalidate(key));
    }

    @Nonnull
    public Mono<Void> invalidateAllAsync() {
        return Mono.fromRunnable(this::invalidateAll);
    }
}

