/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.ApiStatus;
import reactor.core.publisher.Mono;
import ru.tinkoff.kora.cache.caffeine.CaffeineCache;
import ru.tinkoff.kora.cache.caffeine.CaffeineCacheConfig;
import ru.tinkoff.kora.cache.caffeine.CaffeineCacheFactory;
import ru.tinkoff.kora.cache.caffeine.CaffeineCacheTelemetry;

@ApiStatus.Internal
public abstract class AbstractCaffeineCache<K, V>
implements CaffeineCache<K, V> {
    private final String name;
    private final Cache<K, V> caffeine;
    private final CaffeineCacheTelemetry telemetry;

    protected AbstractCaffeineCache(String name, CaffeineCacheConfig config, CaffeineCacheFactory factory, CaffeineCacheTelemetry telemetry) {
        this.name = name;
        this.caffeine = factory.build(name, config);
        this.telemetry = telemetry;
    }

    public V get(@Nonnull K key) {
        if (key == null) {
            return null;
        }
        CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("GET", this.name);
        Object value = this.caffeine.getIfPresent(key);
        telemetryContext.recordSuccess(value);
        return (V)value;
    }

    @Nonnull
    public Map<K, V> get(@Nonnull Collection<K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("GET_MANY", this.name);
        Map values = this.caffeine.getAllPresent(keys);
        telemetryContext.recordSuccess();
        return values;
    }

    public V computeIfAbsent(@Nonnull K key, @Nonnull Function<K, V> mappingFunction) {
        if (key == null) {
            return null;
        }
        CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("PUT_IF_ABSENT", this.name);
        Object value = this.caffeine.get(key, mappingFunction);
        telemetryContext.recordSuccess();
        return (V)value;
    }

    @Nonnull
    public Map<K, V> computeIfAbsent(@Nonnull Collection<K> keys, @Nonnull Function<Set<K>, Map<K, V>> mappingFunction) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("PUT_IF_ABSENT_MANY", this.name);
        Map value = this.caffeine.getAll(keys, ks -> (Map)mappingFunction.apply((Set)ks));
        telemetryContext.recordSuccess();
        return value;
    }

    @Nonnull
    public V put(@Nonnull K key, @Nonnull V value) {
        if (key == null || value == null) {
            return value;
        }
        CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("PUT", this.name);
        this.caffeine.put(key, value);
        telemetryContext.recordSuccess();
        return value;
    }

    public void invalidate(@Nonnull K key) {
        if (key != null) {
            CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("INVALIDATE", this.name);
            this.caffeine.invalidate(key);
            telemetryContext.recordSuccess();
        }
    }

    public void invalidate(@Nonnull Collection<K> keys) {
        if (keys != null && !keys.isEmpty()) {
            CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("INVALIDATE_MANY", this.name);
            this.caffeine.invalidateAll(keys);
            telemetryContext.recordSuccess();
        }
    }

    public void invalidateAll() {
        CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("INVALIDATE_ALL", this.name);
        this.caffeine.invalidateAll();
        telemetryContext.recordSuccess();
    }

    @Nonnull
    public Mono<V> getAsync(@Nonnull K key) {
        return key == null ? Mono.empty() : Mono.fromCallable(() -> this.get(key));
    }

    @Nonnull
    public Mono<Map<K, V>> getAsync(@Nonnull Collection<K> keys) {
        return keys == null || keys.isEmpty() ? Mono.just(Collections.emptyMap()) : Mono.fromCallable(() -> this.get(keys));
    }

    @Nonnull
    public Mono<V> putAsync(@Nonnull K key, @Nonnull V value) {
        if (key == null) {
            return Mono.justOrEmpty(value);
        }
        return Mono.fromCallable(() -> this.put(key, value));
    }

    public Mono<V> computeIfAbsentAsync(@Nonnull K key, @Nonnull Function<K, Mono<V>> mappingFunction) {
        if (key == null) {
            return Mono.empty();
        }
        return Mono.fromCallable(() -> this.computeIfAbsent(key, (K k) -> ((Mono)mappingFunction.apply(k)).block(Duration.ofMinutes(5L))));
    }

    @Nonnull
    public Mono<Map<K, V>> computeIfAbsentAsync(@Nonnull Collection<K> keys, @Nonnull Function<Set<K>, Mono<Map<K, V>>> mappingFunction) {
        if (keys == null || keys.isEmpty()) {
            return Mono.empty();
        }
        return Mono.fromCallable(() -> this.computeIfAbsent(keys, (Set<K> k) -> (Map)((Mono)mappingFunction.apply((Set)k)).block(Duration.ofMinutes(5L))));
    }

    @Nonnull
    public Mono<Boolean> invalidateAsync(@Nonnull K key) {
        if (key == null) {
            return Mono.just((Object)false);
        }
        return Mono.fromCallable(() -> {
            this.invalidate(key);
            return true;
        });
    }

    public Mono<Boolean> invalidateAsync(@Nonnull Collection<K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Mono.just((Object)false);
        }
        return Mono.fromCallable(() -> {
            this.invalidate(keys);
            return true;
        });
    }

    @Nonnull
    public Mono<Boolean> invalidateAllAsync() {
        return Mono.fromCallable(() -> {
            this.invalidateAll();
            return true;
        });
    }
}

