/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.caffeine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.cache.telemetry.CacheMetrics;
import ru.tinkoff.kora.cache.telemetry.CacheTelemetryOperation;
import ru.tinkoff.kora.cache.telemetry.CacheTracer;

public final class CaffeineCacheTelemetry {
    private static final String ORIGIN = "caffeine";
    private static final Logger logger = LoggerFactory.getLogger(CaffeineCacheTelemetry.class);
    private static final TelemetryContext STUB_CONTEXT = new StubCacheTelemetry();
    @Nullable
    private final CacheMetrics metrics;
    @Nullable
    private final CacheTracer tracer;
    private final boolean isStubTelemetry;

    CaffeineCacheTelemetry(@Nullable CacheMetrics metrics, @Nullable CacheTracer tracer) {
        this.metrics = metrics;
        this.tracer = tracer;
        this.isStubTelemetry = metrics == null && tracer == null;
    }

    @Nonnull
    TelemetryContext create(@Nonnull String operationName, @Nonnull String cacheName) {
        if (this.isStubTelemetry) {
            return STUB_CONTEXT;
        }
        return new DefaultCacheTelemetryContext(new Operation(operationName, cacheName));
    }

    static interface TelemetryContext {
        public void recordSuccess();

        public void recordSuccess(@Nullable Object var1);

        public void recordFailure(@Nullable Throwable var1);
    }

    class DefaultCacheTelemetryContext
    implements TelemetryContext {
        private final Operation operation;
        private CacheTracer.CacheSpan span;
        private final long startedInNanos = System.nanoTime();

        DefaultCacheTelemetryContext(Operation operation) {
            logger.trace("Operation '{}' for cache '{}' started", (Object)operation.name(), (Object)operation.cacheName());
            if (CaffeineCacheTelemetry.this.tracer != null) {
                this.span = CaffeineCacheTelemetry.this.tracer.trace((CacheTelemetryOperation)operation);
            }
            this.operation = operation;
        }

        @Override
        public void recordSuccess() {
            this.recordSuccess(null);
        }

        @Override
        public void recordSuccess(@Nullable Object valueFromCache) {
            if (CaffeineCacheTelemetry.this.metrics != null) {
                long durationInNanos = System.nanoTime() - this.startedInNanos;
                CaffeineCacheTelemetry.this.metrics.recordSuccess((CacheTelemetryOperation)this.operation, durationInNanos, valueFromCache);
            }
            if (this.span != null) {
                this.span.recordSuccess();
            }
            if (this.operation.name().startsWith("GET")) {
                if (valueFromCache == null) {
                    logger.trace("Operation '{}' for cache '{}' didn't retried value", (Object)this.operation.name(), (Object)this.operation.cacheName());
                } else {
                    logger.debug("Operation '{}' for cache '{}' retried value", (Object)this.operation.name(), (Object)this.operation.cacheName());
                }
            } else {
                logger.trace("Operation '{}' for cache '{}' completed", (Object)this.operation.name(), (Object)this.operation.cacheName());
            }
        }

        @Override
        public void recordFailure(@Nullable Throwable throwable) {
            if (CaffeineCacheTelemetry.this.metrics != null) {
                long durationInNanos = System.nanoTime() - this.startedInNanos;
                CaffeineCacheTelemetry.this.metrics.recordFailure((CacheTelemetryOperation)this.operation, durationInNanos, throwable);
            }
            if (this.span != null) {
                this.span.recordFailure(throwable);
            }
            if (throwable != null) {
                logger.warn("Operation '{}' failed for cache '{}' with message: {}", new Object[]{this.operation.name(), this.operation.cacheName(), throwable.getMessage()});
            } else {
                logger.warn("Operation '{}' failed for cache '{}'", (Object)this.operation.name(), (Object)this.operation.cacheName());
            }
        }
    }

    record Operation(@Nonnull String name, @Nonnull String cacheName) implements CacheTelemetryOperation
    {
        @Nonnull
        public String origin() {
            return CaffeineCacheTelemetry.ORIGIN;
        }
    }

    record StubCacheTelemetry() implements TelemetryContext
    {
        @Override
        public void recordSuccess() {
        }

        @Override
        public void recordSuccess(@Nullable Object valueFromCache) {
        }

        @Override
        public void recordFailure(@Nullable Throwable throwable) {
        }
    }
}

