/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import ru.tinkoff.kora.cache.caffeine.CaffeineCache;
import ru.tinkoff.kora.cache.caffeine.CaffeineCacheConfig;
import ru.tinkoff.kora.cache.caffeine.CaffeineCacheFactory;
import ru.tinkoff.kora.cache.caffeine.CaffeineCacheTelemetry;

public abstract class AbstractCaffeineCache<K, V>
implements CaffeineCache<K, V> {
    private final String name;
    private final Cache<K, V> caffeine;
    private final CaffeineCacheTelemetry telemetry;

    protected AbstractCaffeineCache(String name, CaffeineCacheConfig config, CaffeineCacheFactory factory, CaffeineCacheTelemetry telemetry) {
        this.name = name;
        this.caffeine = factory.build(name, config);
        this.telemetry = telemetry;
    }

    public V get(@Nonnull K key) {
        if (key == null) {
            return null;
        }
        CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("GET", this.name);
        Object value = this.caffeine.getIfPresent(key);
        telemetryContext.recordSuccess(value);
        return (V)value;
    }

    @Nonnull
    public Map<K, V> get(@Nonnull Collection<K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("GET_MANY", this.name);
        Map values = this.caffeine.getAllPresent(keys);
        telemetryContext.recordSuccess();
        return values;
    }

    @Override
    @Nonnull
    public Map<K, V> getAll() {
        CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("GET_ALL", this.name);
        Map values = Collections.unmodifiableMap(this.caffeine.asMap());
        telemetryContext.recordSuccess();
        return values;
    }

    public V computeIfAbsent(@Nonnull K key, @Nonnull Function<K, V> mappingFunction) {
        if (key == null) {
            return mappingFunction.apply(key);
        }
        CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("COMPUTE_IF_ABSENT", this.name);
        try {
            Object value = this.caffeine.get(key, mappingFunction);
            telemetryContext.recordSuccess();
            return (V)value;
        }
        catch (Exception e) {
            telemetryContext.recordFailure(e);
            throw e;
        }
    }

    @Nonnull
    public Map<K, V> computeIfAbsent(@Nonnull Collection<K> keys, @Nonnull Function<Set<K>, Map<K, V>> mappingFunction) {
        if (keys == null || keys.isEmpty()) {
            return mappingFunction.apply(Collections.emptySet());
        }
        CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("COMPUTE_IF_ABSENT_MANY", this.name);
        try {
            Map value = this.caffeine.getAll(keys, ks -> (Map)mappingFunction.apply((Set)ks));
            telemetryContext.recordSuccess();
            return value;
        }
        catch (Exception e) {
            telemetryContext.recordFailure(e);
            throw e;
        }
    }

    @Nonnull
    public V put(@Nonnull K key, @Nonnull V value) {
        if (key == null || value == null) {
            return value;
        }
        CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("PUT", this.name);
        this.caffeine.put(key, value);
        telemetryContext.recordSuccess();
        return value;
    }

    @Nonnull
    public Map<K, V> put(@Nonnull Map<K, V> keyAndValues) {
        if (keyAndValues == null || keyAndValues.isEmpty()) {
            return Collections.emptyMap();
        }
        CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("PUT_MANY", this.name);
        this.caffeine.putAll(keyAndValues);
        telemetryContext.recordSuccess();
        return keyAndValues;
    }

    public void invalidate(@Nonnull K key) {
        if (key != null) {
            CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("INVALIDATE", this.name);
            this.caffeine.invalidate(key);
            telemetryContext.recordSuccess();
        }
    }

    public void invalidate(@Nonnull Collection<K> keys) {
        if (keys != null && !keys.isEmpty()) {
            CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("INVALIDATE_MANY", this.name);
            this.caffeine.invalidateAll(keys);
            telemetryContext.recordSuccess();
        }
    }

    public void invalidateAll() {
        CaffeineCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("INVALIDATE_ALL", this.name);
        this.caffeine.invalidateAll();
        telemetryContext.recordSuccess();
    }
}

