/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.common;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.ThreadContextElementKt;
import kotlinx.coroutines.reactor.ReactorContextKt;
import reactor.util.context.ContextView;
import ru.tinkoff.kora.common.util.CoroutineContextElement;
import ru.tinkoff.kora.common.util.ReactorContextHook;

public class Context {
    private static final ThreadLocal<Context> INSTANCE = ThreadLocal.withInitial(Context::new);
    private final ConcurrentHashMap<Key<?>, Object> values;

    public String toString() {
        return "Context{" + this.values + "}";
    }

    private Context(ConcurrentHashMap<Key<?>, Object> values) {
        this.values = values;
    }

    private Context() {
        this(new ConcurrentHashMap(8));
    }

    public static Context current() {
        return INSTANCE.get();
    }

    public Context fork() {
        return new Context(this.values.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry((Key)e.getKey(), Context.copy((Key)e.getKey(), e.getValue()))).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, ConcurrentHashMap::new)));
    }

    public void inject() {
        INSTANCE.set(this);
    }

    public static void clear() {
        INSTANCE.remove();
    }

    public <T> T set(Key<T> key, T value) {
        this.values.put(key, value);
        return value;
    }

    public <T> void remove(Key<T> key) {
        this.values.remove(key);
    }

    @Nullable
    public <T> T get(Key<T> key) {
        return (T)this.values.get(key);
    }

    private static <T> T copy(Key<T> key, Object value) {
        return (T)key.copy(value);
    }

    static {
        ReactorContextHook.init();
    }

    public static abstract class Key<T> {
        public final int hashCode() {
            return super.hashCode();
        }

        public final boolean equals(Object obj) {
            return obj == this;
        }

        protected abstract T copy(T var1);
    }

    public static abstract class KeyImmutable<T>
    extends Key<T> {
        @Override
        protected T copy(T object) {
            return object;
        }
    }

    public static class Kotlin {
        public static Context current(CoroutineContext ctx) {
            CoroutineContextElement context = (CoroutineContextElement)ctx.get(CoroutineContextElement.KEY);
            if (context == null) {
                return new Context();
            }
            return context.value();
        }

        public static CoroutineContext inject(CoroutineContext cctx, Context context) {
            reactor.util.context.Context reactorContext = Reactor.inject((ContextView)reactor.util.context.Context.of(Context.class, (Object)cctx), context);
            CoroutineContext coroutineContext = (CoroutineContext)ReactorContextKt.asCoroutineContext((ContextView)reactorContext);
            return cctx.plus(coroutineContext).plus(Kotlin.asCoroutineContext(context));
        }

        public static CoroutineContext asCoroutineContext(Context ctx) {
            return ThreadContextElementKt.asContextElement(INSTANCE, (Object)ctx);
        }
    }

    public static class Reactor {
        public static Context current(ContextView ctx) {
            if (ctx.hasKey(Context.class)) {
                return (Context)ctx.get(Context.class);
            }
            return new Context();
        }

        public static reactor.util.context.Context inject(ContextView ctxView, Context ctx) {
            return reactor.util.context.Context.of((ContextView)ctxView).put(Context.class, (Object)ctx);
        }
    }
}

