/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.common.util;

import javax.annotation.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Either<A, B> {
    @Nullable
    public A left();

    @Nullable
    public B right();

    public static <A, B> Either<A, B> left(A value) {
        return new Left(value);
    }

    public static <A, B> Either<A, B> right(B value) {
        return new Right(value);
    }

    public record Left<A, B>(A value) implements Either<A, B>
    {
        @Override
        public A left() {
            return this.value;
        }

        @Override
        public B right() {
            return null;
        }
    }

    public record Right<A, B>(B value) implements Either<A, B>
    {
        @Override
        @Nullable
        public A left() {
            return null;
        }

        @Override
        @Nullable
        public B right() {
            return this.value;
        }
    }
}

