/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.common.util;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Operators;
import reactor.util.context.ContextView;
import ru.tinkoff.kora.common.Context;

public class ReactorContextHook {
    private static final AtomicBoolean initialized = new AtomicBoolean(false);

    public static void init() {
        if (initialized.compareAndSet(false, true)) {
            Hooks.onEachOperator((String)"ru.tinkoff.kora.ContextLifter", (Function)Operators.lift(Predicate.not(scannable -> scannable instanceof Callable), (scannable, subscriber) -> {
                Context ctx = (Context)subscriber.currentContext().getOrDefault(Context.class, (Object)null);
                if (ctx == null) {
                    ctx = Context.current();
                }
                return new ContextPropagator(subscriber, ctx);
            }));
        }
    }

    private static class ContextPropagator<T>
    implements CoreSubscriber<T> {
        private final CoreSubscriber<T> delegate;
        private final reactor.util.context.Context reactorContext;
        private final Context instance;

        private ContextPropagator(CoreSubscriber<T> delegate, Context current) {
            this.instance = current;
            this.delegate = delegate;
            this.reactorContext = Context.Reactor.inject((ContextView)delegate.currentContext(), this.instance);
        }

        public void onSubscribe(Subscription s) {
            Context current = Context.current();
            if (current == this.instance) {
                this.delegate.onSubscribe(s);
                return;
            }
            this.instance.inject();
            try {
                this.delegate.onSubscribe(s);
            }
            finally {
                current.inject();
            }
        }

        public void onNext(T o) {
            Context current = Context.current();
            if (current == this.instance) {
                this.delegate.onNext(o);
                return;
            }
            this.instance.inject();
            try {
                this.delegate.onNext(o);
            }
            finally {
                current.inject();
            }
        }

        public void onError(Throwable t) {
            Context current = Context.current();
            if (current == this.instance) {
                this.delegate.onError(t);
                return;
            }
            this.instance.inject();
            try {
                this.delegate.onError(t);
            }
            finally {
                current.inject();
            }
        }

        public void onComplete() {
            Context current = Context.current();
            if (current == this.instance) {
                this.delegate.onComplete();
                return;
            }
            this.instance.inject();
            try {
                this.delegate.onComplete();
            }
            finally {
                current.inject();
            }
        }

        @Nonnull
        public reactor.util.context.Context currentContext() {
            return this.reactorContext;
        }
    }
}

