/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.common.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.common.util.flow.DrainSubscriber;
import ru.tinkoff.kora.common.util.flow.EmptySubscription;
import ru.tinkoff.kora.common.util.flow.ErrorSubscription;
import ru.tinkoff.kora.common.util.flow.FromCallablePublisher;
import ru.tinkoff.kora.common.util.flow.FutureSubscriber;
import ru.tinkoff.kora.common.util.flow.OnePublisher;

public class FlowUtils {
    public static <T> CompletionStage<T> toFuture(Flow.Publisher<T> publisher) {
        FutureSubscriber future = new FutureSubscriber();
        publisher.subscribe(future);
        return future;
    }

    public static <T> Flow.Publisher<T> empty(Context context) {
        return subscriber -> {
            EmptySubscription s = new EmptySubscription(context, subscriber);
            subscriber.onSubscribe(s);
        };
    }

    public static <T> Flow.Publisher<T> one(Context context, T value) {
        return new OnePublisher<T>(context, value);
    }

    public static <T> Flow.Publisher<T> fromCallable(Context context, Callable<T> value) {
        return new FromCallablePublisher<T>(context, value);
    }

    public static <T> Flow.Publisher<T> error(Context context, Throwable error) {
        return subscriber -> {
            ErrorSubscription s = new ErrorSubscription(subscriber, context, error);
            subscriber.onSubscribe(s);
        };
    }

    public static <T> Flow.Subscriber<T> drain() {
        return new DrainSubscriber();
    }

    public static CompletableFuture<byte[]> toByteArrayFuture(Flow.Publisher<? extends ByteBuffer> publisher) {
        return FlowUtils.toByteArrayFuture(publisher, Integer.MAX_VALUE);
    }

    public static CompletableFuture<byte[]> toByteArrayFuture(Flow.Publisher<? extends ByteBuffer> publisher, final int maxLength) {
        final CompletableFuture<byte[]> f = new CompletableFuture<byte[]>();
        publisher.subscribe((Flow.Subscriber<? extends ByteBuffer>)new Flow.Subscriber<ByteBuffer>(){
            private final List<ByteBuffer> list = new ArrayList<ByteBuffer>();
            private int length = 0;

            @Override
            public void onSubscribe(Flow.Subscription s) {
                s.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(ByteBuffer byteBuffer) {
                if (this.length < maxLength) {
                    this.list.add(byteBuffer);
                    this.length += byteBuffer.remaining();
                }
            }

            @Override
            public void onError(Throwable t) {
                f.completeExceptionally(t);
            }

            @Override
            public void onComplete() {
                if (this.length == 0) {
                    f.complete(new byte[0]);
                    return;
                }
                byte[] buf = new byte[this.length];
                int offset = 0;
                for (ByteBuffer byteBuffer : this.list) {
                    int remaining = byteBuffer.remaining();
                    byteBuffer.get(buf, offset, remaining);
                    offset += remaining;
                }
                f.complete(buf);
            }
        });
        return f;
    }

    public static CompletableFuture<ByteBuffer> toByteBufferFuture(Flow.Publisher<? extends ByteBuffer> publisher) {
        return FlowUtils.toByteBufferFuture(publisher, Integer.MAX_VALUE);
    }

    public static CompletableFuture<ByteBuffer> toByteBufferFuture(Flow.Publisher<? extends ByteBuffer> publisher, final int maxLength) {
        final CompletableFuture<ByteBuffer> f = new CompletableFuture<ByteBuffer>();
        publisher.subscribe((Flow.Subscriber<? extends ByteBuffer>)new Flow.Subscriber<ByteBuffer>(){
            private final List<ByteBuffer> list = new ArrayList<ByteBuffer>();
            private int length = 0;

            @Override
            public void onSubscribe(Flow.Subscription s) {
                s.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(ByteBuffer byteBuffer) {
                if (this.length < maxLength) {
                    this.list.add(byteBuffer);
                    this.length += byteBuffer.remaining();
                }
            }

            @Override
            public void onError(Throwable t) {
                f.completeExceptionally(t);
            }

            @Override
            public void onComplete() {
                if (this.length == 0) {
                    f.complete(ByteBuffer.allocate(0));
                    return;
                }
                ByteBuffer buf = ByteBuffer.allocate(this.length);
                for (ByteBuffer byteBuffer : this.list) {
                    buf.put(byteBuffer);
                }
                buf.flip();
                f.complete(buf);
            }
        });
        return f;
    }
}

