/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.common.util.flow;

import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.tinkoff.kora.common.Context;

public final class SingleSubscription<T>
extends AtomicBoolean
implements Flow.Subscription {
    private final Flow.Subscriber<? super T> subscriber;
    private final Context context;
    private final T value;

    public SingleSubscription(Flow.Subscriber<? super T> subscriber, Context context, T value) {
        this.subscriber = subscriber;
        this.context = context;
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(long n) {
        assert (n > 0L);
        if (this.compareAndSet(false, true)) {
            Flow.Subscriber<T> subscriber = this.subscriber;
            Context ctx = Context.current();
            this.context.inject();
            try {
                subscriber.onNext(this.value);
                subscriber.onComplete();
            }
            finally {
                ctx.inject();
            }
        }
    }

    @Override
    public void cancel() {
        this.set(true);
    }
}

