/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;

public final class Size {
    private static final long BYTE = 1L;
    private static final long KiB = 1024L;
    private static final long MiB = 0x100000L;
    private static final long GiB = 0x40000000L;
    private static final long TiB = 0x10000000000L;
    private static final long PiB = 0x4000000000000L;
    private static final long EiB = 0x1000000000000000L;
    private static final long KB = 1000L;
    private static final long MB = 1000000L;
    private static final long GB = 1000000000L;
    private static final long TB = 1000000000000L;
    private static final long PB = 1000000000000000L;
    private static final long EB = 1000000000000000000L;
    private static final List<Type> BINARY = List.of(Type.EiB, Type.PiB, Type.TiB, Type.GiB, Type.MiB, Type.KiB, Type.BYTES);
    private static final List<Type> SI = List.of(Type.EB, Type.PB, Type.TB, Type.GB, Type.MB, Type.KB, Type.BYTES);
    private static final List<Type> ALL = List.of(Type.values());
    private final long bytes;
    private final double value;
    private final Type type;

    private Size(long bytes, Type type) {
        this.bytes = bytes;
        this.type = type;
        if (type == Type.BYTES) {
            this.value = bytes;
        } else {
            double v = (double)bytes / (double)type.toBytes();
            BigDecimal bd = BigDecimal.valueOf(v);
            bd = bd.setScale(2, RoundingMode.HALF_UP);
            this.value = bd.doubleValue();
        }
    }

    public long valueExact() {
        return (long)this.value;
    }

    public double valueRounded() {
        return this.value;
    }

    public double valueRounded(int scale) {
        if (scale < 1) {
            return this.valueExact();
        }
        if (scale == 2) {
            return this.valueRounded();
        }
        double v = (double)this.bytes / (double)this.type.toBytes();
        BigDecimal bd = BigDecimal.valueOf(v);
        bd = bd.setScale(scale, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public Type type() {
        return this.type;
    }

    public long toBytes() {
        return this.bytes;
    }

    public Size to(Type type) {
        if (type == this.type) {
            return this;
        }
        return new Size(this.bytes, type);
    }

    public static Size of(long size, Type type) {
        return new Size(size * type.toBytes(), type);
    }

    public static Size ofBytesBinary(long bytes) throws IllegalArgumentException {
        if (bytes < 0L) {
            throw new IllegalArgumentException("Malformed negative value, can't be size: " + bytes);
        }
        for (Type sizeType : BINARY) {
            if (bytes < sizeType.toBytes()) continue;
            return new Size(bytes, sizeType);
        }
        return new Size(bytes, Type.BYTES);
    }

    public static Size ofBytesDecimal(long bytes) throws IllegalArgumentException {
        if (bytes < 0L) {
            throw new IllegalArgumentException("Malformed negative value, can't be size: " + bytes);
        }
        for (Type sizeType : SI) {
            if (bytes < sizeType.toBytes()) continue;
            return new Size(bytes, sizeType);
        }
        return new Size(bytes, Type.BYTES);
    }

    public static Size parse(String value) throws IllegalArgumentException {
        Long size = null;
        Type type = null;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!Character.isLetter(c)) continue;
            try {
                String v = value.substring(0, i).strip();
                size = Long.parseLong(v);
                if (size < 0L) {
                    throw new IllegalArgumentException("Malformed negative value, can't be size: " + value);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Can't extract size number part from: " + value);
            }
            String typeAsStr = value.substring(i).strip();
            for (Type sizeType : ALL) {
                if (sizeType == Type.BYTES && typeAsStr.equalsIgnoreCase("B")) {
                    type = sizeType;
                    break;
                }
                if (!sizeType.name().equalsIgnoreCase(typeAsStr)) continue;
                type = sizeType;
                break;
            }
            if (type != null) break;
            throw new IllegalArgumentException("Can't extract size type part from: " + value);
        }
        if (size == null) {
            try {
                long bytes = Long.parseLong(value);
                if (bytes < 0L) {
                    throw new IllegalArgumentException("Malformed negative value, can't be size: " + value);
                }
                return new Size(bytes, Type.BYTES);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Malformed value, can't be size: " + value);
            }
        }
        return Size.of(size, type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Size size = (Size)o;
        return this.bytes == size.bytes;
    }

    public int hashCode() {
        return Objects.hash(this.bytes);
    }

    public String toString() {
        if (this.type == Type.BYTES) {
            return this.bytes + "B";
        }
        return BigDecimal.valueOf(this.valueRounded()).stripTrailingZeros().toPlainString() + this.type.name();
    }

    public static enum Type {
        BYTES(1L),
        KB(1000L),
        KiB(1024L),
        MB(1000000L),
        MiB(0x100000L),
        GB(1000000000L),
        GiB(0x40000000L),
        TB(1000000000000L),
        TiB(0x10000000000L),
        PB(1000000000000000L),
        PiB(0x4000000000000L),
        EB(1000000000000000000L),
        EiB(0x1000000000000000L);

        private final long bytes;

        private Type(long bytes) {
            this.bytes = bytes;
        }

        public long toBytes() {
            return this.bytes;
        }
    }
}

