/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.common;

import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.ThreadContextElementKt;
import reactor.util.context.ContextView;
import ru.tinkoff.kora.common.util.CoroutineContextElement;
import ru.tinkoff.kora.common.util.ReactorContextHook;

public class Context {
    private static final ThreadLocal<Context> INSTANCE;
    private final ConcurrentHashMap<Key<?>, Object> values;

    public String toString() {
        return "Context{" + String.valueOf(this.values) + "}";
    }

    private Context(ConcurrentHashMap<Key<?>, Object> values) {
        this.values = values;
    }

    private Context() {
        this(new ConcurrentHashMap(8));
    }

    public static Context current() {
        return INSTANCE.get();
    }

    public Context fork() {
        ConcurrentHashMap values = new ConcurrentHashMap(Context.capacity(this.values.size()));
        for (Map.Entry<Key<?>, Object> entry : this.values.entrySet()) {
            Key<?> key = entry.getKey();
            Object copiedValue = Context.copy(key, entry.getValue());
            if (copiedValue == null) continue;
            values.put(key, copiedValue);
        }
        return new Context(values);
    }

    public void inject() {
        INSTANCE.set(this);
    }

    public static Context clear() {
        Context clean = new Context();
        INSTANCE.set(clean);
        return clean;
    }

    public <T> T set(Key<T> key, T value) {
        this.values.put(key, value);
        return value;
    }

    public <T> void remove(Key<T> key) {
        this.values.remove(key);
    }

    @Nullable
    public <T> T get(Key<T> key) {
        return (T)this.values.get(key);
    }

    private static <T> T copy(Key<T> key, Object value) {
        return (T)key.copy(value);
    }

    private static int capacity(int numMappings) {
        return (int)Math.ceil((double)numMappings / 0.75);
    }

    static {
        block3: {
            INSTANCE = ThreadLocal.withInitial(Context::new);
            try {
                ReactorContextHook.init();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (Throwable e) {
                if (e instanceof NoSuchMethodError) break block3;
                throw e;
            }
        }
    }

    public static abstract class Key<T> {
        public final int hashCode() {
            return super.hashCode();
        }

        public final boolean equals(Object obj) {
            return obj == this;
        }

        protected abstract T copy(T var1);
    }

    public static abstract class KeyImmutable<T>
    extends Key<T> {
        @Override
        protected T copy(T object) {
            return object;
        }
    }

    public static class Kotlin {
        public static Context current(CoroutineContext ctx) {
            CoroutineContextElement context = (CoroutineContextElement)ctx.get(CoroutineContextElement.KEY);
            if (context == null) {
                return new Context();
            }
            return context.value();
        }

        public static CoroutineContext asCoroutineContext(Context ctx) {
            return ThreadContextElementKt.asContextElement(INSTANCE, (Object)ctx);
        }
    }

    public static class Reactor {
        public static Context current(ContextView ctx) {
            if (ctx.hasKey(Context.class)) {
                return (Context)ctx.get(Context.class);
            }
            return new Context();
        }

        public static reactor.util.context.Context inject(ContextView ctxView, Context ctx) {
            return reactor.util.context.Context.of((ContextView)ctxView).put(Context.class, (Object)ctx);
        }
    }
}

