/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.config.ConfigValueType;
import java.util.Collection;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public abstract class CollectionConfigValueExtractor<T, C extends Collection<T>>
implements ConfigValueExtractor<C> {
    private final ConfigValueExtractor<T> elementValueExtractor;

    protected CollectionConfigValueExtractor(ConfigValueExtractor<T> elementValueExtractor) {
        this.elementValueExtractor = elementValueExtractor;
    }

    @Override
    public C extract(ConfigValue value) {
        return switch (value.valueType()) {
            case ConfigValueType.NULL -> null;
            case ConfigValueType.STRING -> {
                String[] values = ((String)value.unwrapped()).split(",");
                C result = this.newCollection(values.length);
                for (String stringValue : values) {
                    ConfigValue listValue = ConfigValueFactory.fromAnyRef((Object)stringValue).withOrigin(value.origin());
                    result.add(this.elementValueExtractor.extract(listValue));
                }
                yield result;
            }
            case ConfigValueType.LIST -> {
                ConfigList configList = (ConfigList)value;
                C result = this.newCollection(configList.size());
                for (ConfigValue configValue : configList) {
                    result.add(this.elementValueExtractor.extract(configValue));
                }
                yield result;
            }
            default -> throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValueType.LIST);
        };
    }

    protected abstract C newCollection(int var1);
}

