/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.HashMap;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public class EnumConfigValueExtractor<T extends Enum<T>>
implements ConfigValueExtractor<T> {
    private final HashMap<String, T> map = new HashMap();

    public EnumConfigValueExtractor(Class<T> type) {
        for (Enum enumConstant : (Enum[])type.getEnumConstants()) {
            this.map.put(enumConstant.name(), enumConstant);
        }
    }

    @Override
    public T extract(ConfigValue value) {
        if (value.valueType() == ConfigValueType.STRING) {
            String str = value.unwrapped().toString();
            Enum enumValue = (Enum)this.map.get(str);
            if (enumValue == null) {
                throw ConfigValueExtractionException.parsingError(value, new IllegalArgumentException("Unknown enum value: " + str));
            }
            return (T)enumValue;
        }
        throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValueType.STRING);
    }
}

