/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.LinkedHashMap;
import java.util.Map;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public final class MapConfigValueExtractor<T>
implements ConfigValueExtractor<Map<String, T>> {
    private final ConfigValueExtractor<T> mapValueExtractor;

    public MapConfigValueExtractor(ConfigValueExtractor<T> mapValueExtractor) {
        this.mapValueExtractor = mapValueExtractor;
    }

    @Override
    public Map<String, T> extract(ConfigValue value) {
        switch (value.valueType()) {
            case NULL: {
                return null;
            }
            case OBJECT: {
                ConfigObject configObject = (ConfigObject)value;
                LinkedHashMap<String, T> result = new LinkedHashMap<String, T>(configObject.size());
                for (Map.Entry entry : configObject.entrySet()) {
                    result.put((String)entry.getKey(), this.mapValueExtractor.extract((ConfigValue)entry.getValue()));
                }
                return result;
            }
        }
        throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValueType.OBJECT);
    }
}

