/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public class PropertiesConfigValueExtractor
implements ConfigValueExtractor<Properties> {
    @Override
    public Properties extract(ConfigValue value) {
        if (value.valueType() != ConfigValueType.OBJECT) {
            throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValueType.OBJECT);
        }
        ConfigObject configObject = (ConfigObject)value;
        Properties accumulator = new Properties();
        for (Map.Entry entry : configObject.entrySet()) {
            this.collectAllPaths("", (String)entry.getKey(), (ConfigValue)entry.getValue(), accumulator);
        }
        return accumulator;
    }

    private void collectAllPaths(String previousPath, String key, ConfigValue value, Properties accumulator) {
        switch (value.valueType()) {
            case OBJECT: {
                ConfigObject map = (ConfigObject)value;
                for (Map.Entry entry : map.entrySet()) {
                    this.collectAllPaths(previousPath + key + ".", (String)entry.getKey(), (ConfigValue)entry.getValue(), accumulator);
                }
                break;
            }
            case LIST: {
                ConfigList list = (ConfigList)value;
                ArrayList<Object> res = new ArrayList<Object>();
                for (ConfigValue configValue : list) {
                    ConfigValueType configValueType = configValue.valueType();
                    if (configValueType == ConfigValueType.OBJECT || configValueType == ConfigValueType.LIST) continue;
                    res.add(configValue.unwrapped());
                }
                accumulator.put(previousPath + key, res);
                break;
            }
            default: {
                accumulator.put(previousPath + key, value.unwrapped());
            }
        }
    }
}

