/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public final class BooleanConfigValueExtractor
implements ConfigValueExtractor<Boolean> {
    @Override
    public Boolean extract(ConfigValue value) {
        switch (value.valueType()) {
            case BOOLEAN: {
                return (Boolean)value.unwrapped();
            }
            case STRING: {
                String stringValue = value.unwrapped().toString();
                if (stringValue.equals("true")) {
                    return Boolean.TRUE;
                }
                if (!stringValue.equals("false")) break;
                return Boolean.FALSE;
            }
        }
        throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValueType.BOOLEAN);
    }
}

