/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.math.BigDecimal;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public final class NumberConfigValueExtractor
implements ConfigValueExtractor<BigDecimal> {
    @Override
    public BigDecimal extract(ConfigValue value) {
        switch (value.valueType()) {
            case NUMBER: {
                return new BigDecimal(value.unwrapped().toString());
            }
            case STRING: {
                try {
                    return new BigDecimal((String)value.unwrapped());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValueType.NUMBER);
    }
}

