/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common;

import com.typesafe.config.Config;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.ValueOf;

public class ConfigWatcher
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(ConfigWatcher.class);
    private final ValueOf<Config> applicationConfig;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final int checkTime;
    private volatile Thread thread;

    public ConfigWatcher(ValueOf<Config> applicationConfig, int checkTime) {
        this.applicationConfig = applicationConfig;
        this.checkTime = checkTime;
    }

    public Mono<Void> init() {
        return Mono.fromRunnable(() -> {
            if (this.isStarted.compareAndSet(false, true)) {
                this.thread = new Thread(this::watchJob);
                this.thread.setName("config-reload");
                this.thread.start();
            }
        });
    }

    public Mono<Void> release() {
        return Mono.fromRunnable(() -> {
            if (this.isStarted.compareAndSet(true, false)) {
                this.thread.interrupt();
                this.thread = null;
            }
        });
    }

    private void watchJob() {
        Instant lastModifiedTime;
        Path configPath;
        String filename = System.getProperty("config.file");
        if (filename == null) {
            log.debug("Empty config origin, watch job is cancelled");
            return;
        }
        log.info("Watching for config updates on {}", (Object)filename);
        try {
            configPath = Paths.get(filename, new String[0]).toAbsolutePath().toRealPath(new LinkOption[0]);
            lastModifiedTime = Files.getLastModifiedTime(configPath, new LinkOption[0]).toInstant();
        }
        catch (IOException e) {
            log.warn("Can't locate config file or ", (Throwable)e);
            return;
        }
        while (this.isStarted.get()) {
            try {
                log.trace("Checking config path '{}' (last modified {}) for updates", (Object)filename, (Object)lastModifiedTime);
                Path currentConfigPath = Paths.get(filename, new String[0]).toAbsolutePath().toRealPath(new LinkOption[0]);
                Instant currentLastModifiedTime = Files.getLastModifiedTime(currentConfigPath, new LinkOption[0]).toInstant();
                log.trace("Current config path '{}' (last modified {})", (Object)currentConfigPath, (Object)currentLastModifiedTime);
                if (!currentConfigPath.equals(configPath)) {
                    log.debug("New config symlink target");
                    configPath = currentConfigPath;
                    lastModifiedTime = currentLastModifiedTime;
                    this.applicationConfig.refresh().block();
                    log.info("Config refreshed");
                } else if (currentLastModifiedTime.isAfter(lastModifiedTime)) {
                    log.debug("Config modified");
                    configPath = currentConfigPath;
                    lastModifiedTime = currentLastModifiedTime;
                    this.applicationConfig.refresh().block();
                    log.info("Config refreshed");
                }
                configPath = currentConfigPath;
                lastModifiedTime = currentLastModifiedTime;
                Thread.sleep(this.checkTime);
            }
            catch (InterruptedException currentConfigPath) {
            }
            catch (Exception e) {
                log.warn("Error on checking config for changes", (Throwable)e);
                try {
                    Thread.sleep(this.checkTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

