/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface PathElement {
    public static Index get(int index) {
        return new Index(index);
    }

    public static Key get(String key) {
        return new Key(key);
    }

    public record Index(int index) implements PathElement
    {
        @Override
        public String toString() {
            return Integer.toString(this.index);
        }
    }

    public static final class Key
    implements PathElement {
        private final String name;
        private final List<String> relaxedNames;

        public Key(String name) {
            this.name = name;
            this.relaxedNames = new ArrayList<String>(3);
        }

        public List<String> relaxedNames() {
            if (!this.relaxedNames.isEmpty()) {
                return this.relaxedNames;
            }
            this.relaxedNames.addAll(Key.parseRelaxedNames(this.name));
            return this.relaxedNames;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        private static Set<String> parseRelaxedNames(String fieldName) {
            ArrayList<String> parts = new ArrayList<String>();
            int prevI = 0;
            for (int i = 0; i < fieldName.length(); ++i) {
                boolean hasNext = i + 1 < fieldName.length();
                boolean hasPrevious = i > 0;
                char c = fieldName.charAt(i);
                boolean isDigit = Character.isDigit(c);
                boolean isAlphabetic = Character.isAlphabetic(c);
                boolean isUppercase = Character.isUpperCase(c);
                boolean isLowercase = Character.isLowerCase(c);
                if (hasPrevious) {
                    char prev = fieldName.charAt(i - 1);
                    if (isAlphabetic && isUppercase) {
                        if (!Character.isAlphabetic(prev)) {
                            parts.add(fieldName.substring(prevI, i).toLowerCase());
                            prevI = i;
                        } else if (Character.isLowerCase(prev)) {
                            parts.add(fieldName.substring(prevI, i).toLowerCase());
                            prevI = i;
                        } else if (Character.isUpperCase(prev) && hasNext && Character.isLowerCase(fieldName.charAt(i + 1))) {
                            parts.add(fieldName.substring(prevI, i).toLowerCase());
                            prevI = i;
                        }
                    } else if (isAlphabetic && isLowercase) {
                        if (!Character.isAlphabetic(prev)) {
                            parts.add(fieldName.substring(prevI, i).toLowerCase());
                            prevI = i;
                        }
                    } else if (isDigit) {
                        if (!Character.isDigit(prev)) {
                            parts.add(fieldName.substring(prevI, i).toLowerCase());
                            prevI = i;
                        }
                    } else if (!isAlphabetic && Character.isLetterOrDigit(prev)) {
                        parts.add(fieldName.substring(prevI, i).toLowerCase());
                        prevI = i;
                    }
                }
                if (hasNext) continue;
                parts.add(fieldName.substring(prevI, i + 1).toLowerCase());
            }
            String kebab = String.join((CharSequence)"-", parts);
            String snake = String.join((CharSequence)"_", parts);
            return new LinkedHashSet<String>(List.of(fieldName, kebab, snake));
        }
    }
}

