/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import java.util.HashMap;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public class EnumConfigValueExtractor<T extends Enum<T>>
implements ConfigValueExtractor<T> {
    private final HashMap<String, T> map = new HashMap();

    public EnumConfigValueExtractor(Class<T> type) {
        for (Enum enumConstant : (Enum[])type.getEnumConstants()) {
            this.map.put(enumConstant.name(), enumConstant);
        }
    }

    @Override
    public T extract(ConfigValue<?> value) {
        if (value instanceof ConfigValue.StringValue) {
            ConfigValue.StringValue stringValue = (ConfigValue.StringValue)value;
            String str = stringValue.value();
            Enum enumValue = (Enum)this.map.get(str);
            if (enumValue == null) {
                throw ConfigValueExtractionException.parsingError(value, new IllegalArgumentException("Unknown enum value: " + str));
            }
            return (T)enumValue;
        }
        throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValue.StringValue.class);
    }
}

