/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import java.math.BigDecimal;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public final class NumberConfigValueExtractor
implements ConfigValueExtractor<BigDecimal> {
    @Override
    public BigDecimal extract(ConfigValue<?> value) {
        if (value instanceof ConfigValue.NumberValue) {
            ConfigValue.NumberValue numberValue = (ConfigValue.NumberValue)value;
            return new BigDecimal(numberValue.value().toString());
        }
        if (value instanceof ConfigValue.StringValue) {
            ConfigValue.StringValue stringValue = (ConfigValue.StringValue)value;
            try {
                return new BigDecimal(stringValue.value());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValue.NumberValue.class);
    }
}

