/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public final class BooleanConfigValueExtractor
implements ConfigValueExtractor<Boolean> {
    @Override
    public Boolean extract(ConfigValue<?> value) {
        if (value instanceof ConfigValue.BooleanValue) {
            ConfigValue.BooleanValue booleanValue = (ConfigValue.BooleanValue)value;
            return booleanValue.value();
        }
        if (value instanceof ConfigValue.StringValue) {
            ConfigValue.StringValue str = (ConfigValue.StringValue)value;
            String stringValue = str.value();
            if (stringValue.equals("true")) {
                return Boolean.TRUE;
            }
            if (stringValue.equals("false")) {
                return Boolean.FALSE;
            }
        }
        throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValue.BooleanValue.class);
    }
}

