/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.impl.SimpleConfigValuePath;

public interface ConfigValuePath {
    public static final ConfigValuePath ROOT = new SimpleConfigValuePath(null, null);
    public static final Pattern ARRAY_ELEMENT_PATTERN = Pattern.compile("(?<array>.*)\\[(?<number>\\d+)]");

    public PathElement last();

    public ConfigValuePath prev();

    public static ConfigValuePath root() {
        return ROOT;
    }

    default public ConfigValuePath child(PathElement path) {
        return new SimpleConfigValuePath(Objects.requireNonNull(path), this);
    }

    default public ConfigValuePath child(String key) {
        return new SimpleConfigValuePath(new PathElement.Key(Objects.requireNonNull(key)), this);
    }

    default public ConfigValuePath child(int index) {
        return new SimpleConfigValuePath(new PathElement.Index(index), this);
    }

    public static ConfigValuePath parse(String reference) {
        if (reference.equals(".")) {
            return ConfigValuePath.root();
        }
        String[] elements = reference.split("\\.");
        ConfigValuePath path = ConfigValuePath.root();
        for (String element : elements) {
            String elementPath = element.trim();
            Matcher matcher = ARRAY_ELEMENT_PATTERN.matcher(elementPath);
            if (matcher.matches()) {
                String arrayPath = matcher.group(1);
                int arrayIndex = Integer.parseInt(matcher.group(2));
                path = path.child(arrayPath).child(arrayIndex);
                continue;
            }
            path = path.child(elementPath);
        }
        return path;
    }
}

