/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common;

import jakarta.annotation.Nullable;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import ru.tinkoff.kora.config.common.ConfigValueOrigin;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConfigValue<T> {
    @Nullable
    public T value();

    public ConfigValueOrigin origin();

    default public String asString() {
        ConfigValue configValue = this;
        if (configValue instanceof StringValue) {
            StringValue str = (StringValue)configValue;
            return str.value();
        }
        configValue = this;
        if (configValue instanceof NumberValue) {
            NumberValue number = (NumberValue)configValue;
            return number.value().toString();
        }
        configValue = this;
        if (configValue instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)configValue;
            return booleanValue.value() != false ? "true" : "false";
        }
        throw ConfigValueExtractionException.unexpectedValueType(this, StringValue.class);
    }

    default public Number asNumber() {
        ConfigValue configValue = this;
        if (configValue instanceof StringValue) {
            StringValue str = (StringValue)configValue;
            try {
                return new BigDecimal(str.value());
            }
            catch (NumberFormatException e) {
                throw ConfigValueExtractionException.parsingError(this, e);
            }
        }
        configValue = this;
        if (configValue instanceof NumberValue) {
            NumberValue number = (NumberValue)configValue;
            return number.value();
        }
        throw ConfigValueExtractionException.unexpectedValueType(this, NumberValue.class);
    }

    default public ArrayValue asArray() {
        ConfigValue configValue = this;
        if (configValue instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)configValue;
            return arrayValue;
        }
        throw ConfigValueExtractionException.unexpectedValueType(this, ArrayValue.class);
    }

    default public ObjectValue asObject() {
        ConfigValue configValue = this;
        if (configValue instanceof ObjectValue) {
            ObjectValue object = (ObjectValue)configValue;
            return object;
        }
        throw ConfigValueExtractionException.unexpectedValueType(this, ObjectValue.class);
    }

    default public boolean asBoolean() {
        ConfigValue configValue = this;
        if (configValue instanceof StringValue) {
            StringValue str = (StringValue)configValue;
            return Boolean.parseBoolean(str.value());
        }
        configValue = this;
        if (configValue instanceof BooleanValue) {
            BooleanValue bv = (BooleanValue)configValue;
            return bv.value;
        }
        throw ConfigValueExtractionException.unexpectedValueType(this, BooleanValue.class);
    }

    default public boolean isNull() {
        return this instanceof NullValue;
    }

    public static final class StringValue
    extends Record
    implements ConfigValue<String> {
        private final ConfigValueOrigin origin;
        private final String value;

        public StringValue(ConfigValueOrigin origin, String value) {
            Objects.requireNonNull(origin);
            Objects.requireNonNull(value);
            this.origin = origin;
            this.value = value;
        }

        @Override
        public String toString() {
            return "\"" + this.value + "\"";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StringValue.class, "origin;value", "origin", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StringValue.class, "origin;value", "origin", "value"}, this, o);
        }

        @Override
        public ConfigValueOrigin origin() {
            return this.origin;
        }

        @Override
        public String value() {
            return this.value;
        }
    }

    public static final class NumberValue
    extends Record
    implements ConfigValue<Number> {
        private final ConfigValueOrigin origin;
        private final Number value;

        public NumberValue(ConfigValueOrigin origin, Number value) {
            Objects.requireNonNull(origin);
            Objects.requireNonNull(value);
            this.origin = origin;
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value.toString();
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NumberValue.class, "origin;value", "origin", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NumberValue.class, "origin;value", "origin", "value"}, this, o);
        }

        @Override
        public ConfigValueOrigin origin() {
            return this.origin;
        }

        @Override
        public Number value() {
            return this.value;
        }
    }

    public static final class BooleanValue
    extends Record
    implements ConfigValue<Boolean> {
        private final ConfigValueOrigin origin;
        private final Boolean value;

        public BooleanValue(ConfigValueOrigin origin, Boolean value) {
            Objects.requireNonNull(origin);
            Objects.requireNonNull(value);
            this.origin = origin;
            this.value = value;
        }

        @Override
        public String toString() {
            return Objects.toString(this.value);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BooleanValue.class, "origin;value", "origin", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BooleanValue.class, "origin;value", "origin", "value"}, this, o);
        }

        @Override
        public ConfigValueOrigin origin() {
            return this.origin;
        }

        @Override
        public Boolean value() {
            return this.value;
        }
    }

    public static final class ArrayValue
    extends Record
    implements ConfigValue<List<ConfigValue<?>>>,
    Iterable<ConfigValue<?>> {
        private final ConfigValueOrigin origin;
        private final List<ConfigValue<?>> value;

        public ArrayValue(ConfigValueOrigin origin, List<ConfigValue<?>> value) {
            Objects.requireNonNull(origin);
            Objects.requireNonNull(value);
            this.origin = origin;
            this.value = value;
        }

        public ConfigValue<?> get(int i) {
            return Objects.requireNonNull(this.value.get(i));
        }

        @Override
        public Iterator<ConfigValue<?>> iterator() {
            return this.value.iterator();
        }

        @Override
        public String toString() {
            return this.value.stream().map(Objects::toString).collect(Collectors.joining(", ", "[", "]"));
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ArrayValue.class, "origin;value", "origin", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ArrayValue.class, "origin;value", "origin", "value"}, this, o);
        }

        @Override
        public ConfigValueOrigin origin() {
            return this.origin;
        }

        @Override
        public List<ConfigValue<?>> value() {
            return this.value;
        }
    }

    public static final class ObjectValue
    extends Record
    implements ConfigValue<Map<String, ConfigValue<?>>>,
    Iterable<Map.Entry<String, ConfigValue<?>>> {
        private final ConfigValueOrigin origin;
        private final Map<String, ConfigValue<?>> value;

        public ObjectValue(ConfigValueOrigin origin, Map<String, ConfigValue<?>> value) {
            Objects.requireNonNull(origin);
            Objects.requireNonNull(value);
            this.origin = origin;
            this.value = value;
        }

        public ConfigValue<?> get(String key) {
            return this.get(new PathElement.Key(key));
        }

        public ConfigValue<?> get(PathElement.Key key) {
            ConfigValue<?> value = this.value.get(key.name());
            if (value != null) {
                return value;
            }
            for (String relaxedName : key.relaxedNames()) {
                value = this.value.get(relaxedName);
                if (value == null) continue;
                return value;
            }
            return new NullValue(this.origin.child(key));
        }

        @Override
        public Iterator<Map.Entry<String, ConfigValue<?>>> iterator() {
            return this.value.entrySet().iterator();
        }

        @Override
        public String toString() {
            return this.value.entrySet().stream().map(e -> ("\"" + (String)e.getKey() + "\": " + e.getValue()).indent(2).stripTrailing() + ",\n").collect(Collectors.joining("", "{\n", "}"));
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ObjectValue.class, "origin;value", "origin", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ObjectValue.class, "origin;value", "origin", "value"}, this, o);
        }

        @Override
        public ConfigValueOrigin origin() {
            return this.origin;
        }

        @Override
        public Map<String, ConfigValue<?>> value() {
            return this.value;
        }
    }

    public record NullValue(ConfigValueOrigin origin) implements ConfigValue<Void>
    {
        public NullValue {
            Objects.requireNonNull(origin);
        }

        @Override
        public String toString() {
            return "null";
        }

        @Override
        public Void value() {
            return null;
        }
    }
}

