/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.config.common.origin.ConfigOrigin;
import ru.tinkoff.kora.config.common.origin.ContainerConfigOrigin;
import ru.tinkoff.kora.config.common.origin.FileConfigOrigin;

public class ConfigWatcher
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(ConfigWatcher.class);
    private final Optional<ValueOf<ConfigOrigin>> applicationConfig;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final int checkTime;
    private volatile Thread thread;

    public ConfigWatcher(Optional<ValueOf<ConfigOrigin>> applicationConfig, int checkTime) {
        this.applicationConfig = applicationConfig;
        this.checkTime = checkTime;
    }

    public void init() {
        if (this.applicationConfig.isEmpty()) {
            return;
        }
        if (this.isStarted.compareAndSet(false, true)) {
            this.thread = new Thread(this::watchJob);
            this.thread.setName("config-reload");
            this.thread.start();
        }
    }

    public void release() {
        if (this.applicationConfig.isEmpty()) {
            return;
        }
        if (this.isStarted.compareAndSet(true, false)) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    private void watchJob() {
        if (this.applicationConfig.isEmpty()) {
            return;
        }
        ConfigOrigin config = (ConfigOrigin)this.applicationConfig.get().get();
        List<FileConfigOrigin> origins = this.parseOrigin(config);
        if (origins.isEmpty()) {
            return;
        }
        record State(Path configPath, Instant lastModifiedTime) {
        }
        Function<Path, State> stateExtractor = configuredPath -> {
            try {
                Path configPath = configuredPath.toAbsolutePath().toRealPath(new LinkOption[0]);
                Instant lastModifiedTime = Files.getLastModifiedTime(configPath, new LinkOption[0]).toInstant();
                return new State(configPath, lastModifiedTime);
            }
            catch (IOException e) {
                log.warn("Can't locate config file or ", (Throwable)e);
                return null;
            }
        };
        HashMap<Path, State> state = new HashMap<Path, State>();
        for (FileConfigOrigin fileConfigOrigin : origins) {
            State state2 = stateExtractor.apply(fileConfigOrigin.path());
            state.put(fileConfigOrigin.path(), state2);
        }
        while (this.isStarted.get()) {
            HashMap<Path, State> changed = new HashMap<Path, State>();
            for (Map.Entry entry : state.entrySet()) {
                Path path = (Path)entry.getKey();
                State newState = stateExtractor.apply(path);
                if (newState == null) continue;
                if (entry.getValue() == null) {
                    log.debug("New config symlink target");
                    changed.put((Path)entry.getKey(), newState);
                    continue;
                }
                Path configPath = ((State)entry.getValue()).configPath();
                Instant lastModifiedTime = ((State)entry.getValue()).lastModifiedTime();
                Path currentConfigPath = newState.configPath;
                Instant currentLastModifiedTime = newState.lastModifiedTime;
                if (!currentConfigPath.equals(configPath)) {
                    log.debug("New config symlink target");
                    changed.put((Path)entry.getKey(), newState);
                    continue;
                }
                if (!currentLastModifiedTime.isAfter(lastModifiedTime)) continue;
                log.debug("Config modified");
                changed.put((Path)entry.getKey(), newState);
            }
            try {
                if (!changed.isEmpty()) {
                    this.applicationConfig.get().refresh();
                    log.info("Config refreshed");
                    state.putAll(changed);
                }
                Thread.sleep(this.checkTime);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                log.warn("Error on checking config for changes", (Throwable)exception);
                try {
                    Thread.sleep(this.checkTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private List<FileConfigOrigin> parseOrigin(ConfigOrigin origin) {
        if (origin instanceof FileConfigOrigin) {
            FileConfigOrigin o = (FileConfigOrigin)origin;
            return List.of(o);
        }
        if (origin instanceof ContainerConfigOrigin) {
            ContainerConfigOrigin o = (ContainerConfigOrigin)origin;
            ArrayList<FileConfigOrigin> result = new ArrayList<FileConfigOrigin>();
            for (ConfigOrigin configOrigin : o.origins()) {
                result.addAll(this.parseOrigin(configOrigin));
            }
            return result;
        }
        return List.of();
    }
}

