/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import java.util.Collection;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public abstract class CollectionConfigValueExtractor<T, C extends Collection<T>>
implements ConfigValueExtractor<C> {
    private final ConfigValueExtractor<T> elementValueExtractor;

    protected CollectionConfigValueExtractor(ConfigValueExtractor<T> elementValueExtractor) {
        this.elementValueExtractor = elementValueExtractor;
    }

    @Override
    public C extract(ConfigValue<?> value) {
        if (value instanceof ConfigValue.StringValue) {
            ConfigValue.StringValue str = (ConfigValue.StringValue)value;
            String[] values = str.value().split(",");
            C result = this.newCollection(values.length);
            for (String stringValue : values) {
                ConfigValue.StringValue listValue = new ConfigValue.StringValue(str.origin(), stringValue.trim());
                result.add(this.elementValueExtractor.extract(listValue));
            }
            return result;
        }
        if (value instanceof ConfigValue.ArrayValue) {
            ConfigValue.ArrayValue array = (ConfigValue.ArrayValue)value;
            C result = this.newCollection(array.value().size());
            for (ConfigValue<?> element : array) {
                result.add(this.elementValueExtractor.extract(element));
            }
            return result;
        }
        throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValue.ArrayValue.class);
    }

    protected abstract C newCollection(int var1);
}

