/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public class PropertiesConfigValueExtractor
implements ConfigValueExtractor<Properties> {
    @Override
    public Properties extract(ConfigValue<?> value) {
        if (!(value instanceof ConfigValue.ObjectValue)) {
            throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValue.ObjectValue.class);
        }
        ConfigValue.ObjectValue objectValue = (ConfigValue.ObjectValue)value;
        Properties accumulator = new Properties();
        for (Map.Entry<String, ConfigValue<?>> entry : objectValue) {
            this.collectAllPaths("", entry.getKey(), entry.getValue(), accumulator);
        }
        return accumulator;
    }

    private void collectAllPaths(String previousPath, String key, ConfigValue<?> value, Properties accumulator) {
        if (value instanceof ConfigValue.ObjectValue) {
            ConfigValue.ObjectValue objectValue = (ConfigValue.ObjectValue)value;
            for (Map.Entry<String, ConfigValue<?>> entry : objectValue) {
                this.collectAllPaths(previousPath + key + ".", entry.getKey(), entry.getValue(), accumulator);
            }
        } else if (value instanceof ConfigValue.ArrayValue) {
            ConfigValue.ArrayValue arrayValue = (ConfigValue.ArrayValue)value;
            ArrayList res = new ArrayList();
            for (ConfigValue<?> configValue : arrayValue) {
                if (configValue instanceof ConfigValue.ObjectValue || configValue instanceof ConfigValue.ArrayValue) continue;
                res.add(configValue.value());
            }
            accumulator.put(previousPath + key, res);
        } else {
            accumulator.put(previousPath + key, value.value());
        }
    }
}

