/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import jakarta.annotation.Nullable;
import java.util.Objects;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public class DoubleArrayConfigValueExtractor
implements ConfigValueExtractor<double[]> {
    private final ConfigValueExtractor<Double> doubleConfigValueExtractor;

    public DoubleArrayConfigValueExtractor(ConfigValueExtractor<Double> doubleConfigValueExtractor) {
        this.doubleConfigValueExtractor = doubleConfigValueExtractor;
    }

    @Override
    @Nullable
    public double[] extract(ConfigValue<?> value) {
        ConfigValue.ArrayValue array = value.asArray();
        double[] result = new double[array.value().size()];
        for (int i = 0; i < result.length; ++i) {
            ConfigValue item = (ConfigValue)array.value().get(i);
            if (item.isNull()) {
                throw ConfigValueExtractionException.unexpectedValueType(item, ConfigValue.NumberValue.class);
            }
            result[i] = Objects.requireNonNull(this.doubleConfigValueExtractor.extract(item));
        }
        return result;
    }
}

