/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.ConfigValuePath;
import ru.tinkoff.kora.config.common.impl.SimpleConfig;
import ru.tinkoff.kora.config.common.origin.EnvironmentOrigin;
import ru.tinkoff.kora.config.common.origin.SystemPropertiesOrigin;

public final class ConfigResolver {
    public static Config resolve(Config config) {
        ResolveContext ctx;
        ConfigValue.ObjectValue newRoot;
        String resolveSystemProperty = System.getenv("KORA_SYSTEM_PROPERTIES_RESOLVE_ENABLED");
        if (resolveSystemProperty == null) {
            resolveSystemProperty = System.getProperty("kora.system.properties.resolve.enabled", "true");
        }
        if ((newRoot = ConfigResolver.resolve(ctx = new ResolveContext(config, new ArrayDeque<ConfigValuePath>(), Boolean.parseBoolean(resolveSystemProperty)), config.root())) == config.root()) {
            return config;
        }
        return new SimpleConfig(config.origin(), newRoot);
    }

    private static ConfigValue.ObjectValue resolve(ResolveContext ctx, ConfigValue.ObjectValue object) {
        LinkedHashMap newContent = new LinkedHashMap();
        boolean changed = false;
        for (Map.Entry<String, ConfigValue<?>> entry : object) {
            String key = entry.getKey();
            ConfigValue<?> value = entry.getValue();
            ConfigValue<?> newValue = ConfigResolver.resolve(ctx, value);
            newContent.put(key, newValue);
            if (newValue == value) continue;
            changed = true;
        }
        if (!changed) {
            return object;
        }
        return new ConfigValue.ObjectValue(object.origin(), newContent);
    }

    private static ConfigValue.ArrayValue resolve(ResolveContext ctx, ConfigValue.ArrayValue array) {
        ArrayList newContent = new ArrayList(array.value().size());
        boolean changed = false;
        for (ConfigValue<?> value : array) {
            ConfigValue<?> newValue = ConfigResolver.resolve(ctx, value);
            newContent.add(newValue);
            if (newValue == value) continue;
            changed = true;
        }
        if (!changed) {
            return array;
        }
        return new ConfigValue.ArrayValue(array.origin(), newContent);
    }

    private static ConfigValue<?> resolve(ResolveContext ctx, ConfigValue<?> value) {
        if (value instanceof ConfigValue.ObjectValue) {
            ConfigValue.ObjectValue objectValue = (ConfigValue.ObjectValue)value;
            return ConfigResolver.resolve(ctx, objectValue);
        }
        if (value instanceof ConfigValue.ArrayValue) {
            ConfigValue.ArrayValue arrayValue = (ConfigValue.ArrayValue)value;
            return ConfigResolver.resolve(ctx, arrayValue);
        }
        if (value instanceof ConfigValue.NumberValue) {
            return value;
        }
        if (value instanceof ConfigValue.BooleanValue) {
            return value;
        }
        if (value instanceof ConfigValue.StringValue) {
            ConfigValue.StringValue stringValue = (ConfigValue.StringValue)value;
            return ConfigResolver.resolve(ctx, stringValue);
        }
        throw new IllegalStateException("Unknown value type: " + value.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigValue<?> resolve(ResolveContext ctx, ConfigValue.StringValue stringValue) {
        if (stringValue.origin().config() instanceof EnvironmentOrigin) {
            return stringValue;
        }
        if (stringValue.origin().config() instanceof SystemPropertiesOrigin && !ctx.resolveProperties()) {
            return stringValue;
        }
        char[] buf = stringValue.value().toCharArray();
        ArrayList parts = new ArrayList();
        static enum Token {
            STRING,
            REFERENCE,
            REFERENCE_DEFAULT_VALUE,
            REFERENCE_NULLABLE;

        }
        Token token = Token.STRING;
        int tokenStart = 0;
        int prevTokenStart = 0;
        for (int i = 0; i < buf.length; ++i) {
            ConfigValue<?> value;
            ConfigValuePath path;
            char c = buf[i];
            if (c == '$' && buf.length > i + 2 && buf[i + 1] == '{' && (i == 0 || buf[i - 1] != '\\')) {
                if (token != Token.STRING) continue;
                token = buf[i + 2] == '?' ? Token.REFERENCE_NULLABLE : Token.REFERENCE;
                int n = i - tokenStart;
                if (n > 0) {
                    parts.add(new ConfigValue.StringValue(stringValue.origin(), new String(buf, tokenStart, n)));
                }
                prevTokenStart = tokenStart;
                tokenStart = ++i + 1;
                if (token != Token.REFERENCE_NULLABLE) continue;
                ++tokenStart;
                continue;
            }
            if (c == ':' && token == Token.REFERENCE) {
                token = Token.REFERENCE_DEFAULT_VALUE;
                prevTokenStart = tokenStart;
                tokenStart = i + 1;
                continue;
            }
            if (c != '}') continue;
            if (token == Token.REFERENCE) {
                String string = new String(buf, tokenStart, i - tokenStart);
                path = ConfigValuePath.parse(string);
                ctx.chain().add(path);
                value = ctx.root().get(path);
                if (value instanceof ConfigValue.NullValue) {
                    throw new RuntimeException("Unresolved path: " + string);
                }
                ctx.chain().push(path);
                try {
                    parts.add(ConfigResolver.resolve(ctx, value));
                }
                finally {
                    ctx.chain().pop();
                }
                prevTokenStart = tokenStart;
                tokenStart = i + 1;
                token = Token.STRING;
                continue;
            }
            if (token == Token.REFERENCE_NULLABLE) {
                String string = new String(buf, tokenStart, i - tokenStart);
                path = ConfigValuePath.parse(string);
                ctx.chain().add(path);
                value = ctx.root().get(path);
                if (value instanceof ConfigValue.NullValue) {
                    parts.add(value);
                } else {
                    ctx.chain().push(path);
                    try {
                        parts.add(ConfigResolver.resolve(ctx, value));
                    }
                    finally {
                        ctx.chain().pop();
                    }
                }
                prevTokenStart = tokenStart;
                tokenStart = i + 1;
                token = Token.STRING;
                continue;
            }
            if (token != Token.REFERENCE_DEFAULT_VALUE) continue;
            String string = new String(buf, prevTokenStart, tokenStart - prevTokenStart - 1);
            String defaultValue = new String(buf, tokenStart, i - tokenStart);
            ConfigValuePath path2 = ConfigValuePath.parse(string);
            ConfigValue<?> value2 = ctx.root().get(path2);
            if (value2 instanceof ConfigValue.NullValue) {
                ctx.chain().push(path2);
                try {
                    parts.add(ConfigResolver.resolve(ctx, new ConfigValue.StringValue(stringValue.origin(), defaultValue)));
                }
                finally {
                    ctx.chain().pop();
                }
            }
            ctx.chain().push(path2);
            try {
                parts.add(ConfigResolver.resolve(ctx, value2));
            }
            finally {
                ctx.chain().pop();
            }
            prevTokenStart = tokenStart;
            tokenStart = i + 1;
            token = Token.STRING;
        }
        if (parts.size() == 0) {
            return stringValue;
        }
        if (tokenStart < buf.length) {
            parts.add(new ConfigValue.StringValue(stringValue.origin(), new String(buf, tokenStart, buf.length - tokenStart)));
        }
        if (parts.size() == 1) {
            return (ConfigValue)parts.get(0);
        }
        StringBuilder sb = new StringBuilder();
        for (ConfigValue configValue : parts) {
            if (configValue instanceof ConfigValue.StringValue) {
                ConfigValue.StringValue strValue = (ConfigValue.StringValue)configValue;
                sb.append(strValue.value());
                continue;
            }
            if (configValue instanceof ConfigValue.NumberValue) {
                ConfigValue.NumberValue numberValue = (ConfigValue.NumberValue)configValue;
                sb.append(numberValue.value());
                continue;
            }
            if (configValue instanceof ConfigValue.NullValue) continue;
            throw new RuntimeException("Unexpected type: " + configValue.getClass());
        }
        String value = sb.toString();
        return new ConfigValue.StringValue(stringValue.origin(), value);
    }

    private record ResolveContext(Config root, ArrayDeque<ConfigValuePath> chain, boolean resolveProperties) {
    }
}

