/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common;

import java.util.LinkedList;
import java.util.Map;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.ConfigValueOrigin;
import ru.tinkoff.kora.config.common.ConfigValuePath;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;

public class ConfigHelper {
    public static ConfigValue<?> get(Config config, ConfigValuePath path) {
        ConfigValue<Map<String, ConfigValue<?>>> value = config.root();
        LinkedList<PathElement> parts = new LinkedList<PathElement>();
        while (path != null && path.last() != null) {
            parts.addFirst(path.last());
            path = path.prev();
        }
        for (int j = 0; j < parts.size(); ++j) {
            PathElement part = (PathElement)parts.get(j);
            if (part instanceof PathElement.Index) {
                PathElement.Index i = (PathElement.Index)part;
                if (value instanceof ConfigValue.ArrayValue) {
                    ConfigValue.ArrayValue arrayValue = (ConfigValue.ArrayValue)value;
                    if (!((value = arrayValue.get(i.index())) instanceof ConfigValue.NullValue)) continue;
                    ConfigValueOrigin origin = arrayValue.origin();
                    do {
                        origin = origin.child((PathElement)parts.get(j));
                    } while (++j < parts.size());
                    return new ConfigValue.NullValue(origin);
                }
                throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValue.ArrayValue.class);
            }
            if (part instanceof PathElement.Key) {
                PathElement.Key f = (PathElement.Key)part;
                if (value instanceof ConfigValue.ObjectValue) {
                    ConfigValue.ObjectValue objectValue = value;
                    if (!((value = objectValue.get(f)) instanceof ConfigValue.NullValue)) continue;
                    ConfigValueOrigin origin = objectValue.origin();
                    do {
                        origin = origin.child((PathElement)parts.get(j));
                    } while (++j < parts.size());
                    return new ConfigValue.NullValue(origin);
                }
                throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValue.ArrayValue.class);
            }
            throw new IllegalStateException();
        }
        return value;
    }
}

