/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common;

import jakarta.annotation.Nullable;
import java.util.Optional;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.common.annotation.Root;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.ConfigWatcher;
import ru.tinkoff.kora.config.common.DefaultConfigExtractorsModule;
import ru.tinkoff.kora.config.common.annotation.ApplicationConfig;
import ru.tinkoff.kora.config.common.annotation.Environment;
import ru.tinkoff.kora.config.common.annotation.SystemProperties;
import ru.tinkoff.kora.config.common.factory.MapConfigFactory;
import ru.tinkoff.kora.config.common.factory.MergeConfigFactory;
import ru.tinkoff.kora.config.common.origin.ConfigOrigin;
import ru.tinkoff.kora.config.common.origin.EnvironmentOrigin;
import ru.tinkoff.kora.config.common.origin.SystemPropertiesOrigin;

public interface CommonConfigModule
extends DefaultConfigExtractorsModule {
    @Environment
    default public Config environmentConfig() {
        return MapConfigFactory.fromMap(new EnvironmentOrigin("Environment Variables"), System.getenv());
    }

    @SystemProperties
    default public Config systemProperties() {
        return MapConfigFactory.fromProperties(new SystemPropertiesOrigin("System Properties"), System.getProperties());
    }

    default public Config config(@Environment Config environment, @SystemProperties Config systemProperties, @Nullable @ApplicationConfig Config applicationConfig) {
        Config config = MergeConfigFactory.merge(environment, systemProperties);
        if (applicationConfig != null) {
            config = MergeConfigFactory.merge(config, applicationConfig);
        }
        return config.resolve();
    }

    @Root
    default public ConfigWatcher configRefresher(@ApplicationConfig Optional<ValueOf<ConfigOrigin>> applicationConfig) {
        return new ConfigWatcher(applicationConfig, 1000);
    }
}

