/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import ru.tinkoff.kora.application.graph.TypeRef;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.common.util.Either;
import ru.tinkoff.kora.common.util.Size;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.BooleanConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.DoubleArrayConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.DurationConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.EitherConfigExtractor;
import ru.tinkoff.kora.config.common.extractor.EnumConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.ListConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.LocalDateConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.LocalDateTimeConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.LocalTimeConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.MapConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.NumberConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.OffsetDateTimeConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.OffsetTimeConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.OptionalConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.PatternConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.PeriodConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.PropertiesConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.SetConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.SizeConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.StringConfigValueExtractor;
import ru.tinkoff.kora.config.common.extractor.UUIDConfigValueExtractor;

public interface DefaultConfigExtractorsModule {
    default public <T> ConfigValueExtractor<List<T>> listConfigValueExtractor(ConfigValueExtractor<T> elementValueExtractor) {
        return new ListConfigValueExtractor<T>(elementValueExtractor);
    }

    default public <T> ConfigValueExtractor<Set<T>> setConfigValueExtractor(ConfigValueExtractor<T> elementValueExtractor) {
        return new SetConfigValueExtractor<T>(elementValueExtractor);
    }

    default public <T> ConfigValueExtractor<Map<String, T>> mapConfigValueExtractor(ConfigValueExtractor<T> listValueExtractor) {
        return new MapConfigValueExtractor<T>(listValueExtractor);
    }

    @DefaultComponent
    default public <T> OptionalConfigValueExtractor<T> optionalConfigValueExtractor(ConfigValueExtractor<T> extractor) {
        return new OptionalConfigValueExtractor<T>(extractor);
    }

    default public <T extends Enum<T>> EnumConfigValueExtractor<T> enumConfigValueExtractor(TypeRef<T> typeRef) {
        return new EnumConfigValueExtractor(typeRef.getRawType());
    }

    default public ConfigValueExtractor<String> stringConfigValueExtractor() {
        return new StringConfigValueExtractor();
    }

    default public ConfigValueExtractor<Integer> integerConfigValueExtractor() {
        return new NumberConfigValueExtractor().map(BigDecimal::intValueExact);
    }

    default public ConfigValueExtractor<Long> longConfigValueExtractor() {
        return new NumberConfigValueExtractor().map(BigDecimal::longValueExact);
    }

    default public ConfigValueExtractor<BigInteger> bigIntegerConfigValueExtractor() {
        return new NumberConfigValueExtractor().map(BigDecimal::toBigInteger);
    }

    default public ConfigValueExtractor<Float> floatConfigValueExtractor() {
        return new NumberConfigValueExtractor().map(BigDecimal::floatValue);
    }

    default public ConfigValueExtractor<Double> doubleConfigValueExtractor() {
        return new NumberConfigValueExtractor().map(BigDecimal::doubleValue);
    }

    default public ConfigValueExtractor<BigDecimal> bigDecimalConfigValueExtractor() {
        return new NumberConfigValueExtractor();
    }

    default public ConfigValueExtractor<Boolean> booleanConfigValueExtractor() {
        return new BooleanConfigValueExtractor();
    }

    default public ConfigValueExtractor<ConfigValue.ObjectValue> subconfigConfigValueExtractor() {
        return ConfigValue::asObject;
    }

    default public ConfigValueExtractor<Duration> durationConfigValueExtractor() {
        return new DurationConfigValueExtractor();
    }

    default public ConfigValueExtractor<Period> periodConfigValueExtractor() {
        return new PeriodConfigValueExtractor();
    }

    default public ConfigValueExtractor<Properties> propertiesConfigValueExtractor() {
        return new PropertiesConfigValueExtractor();
    }

    default public ConfigValueExtractor<Pattern> patternConfigValueExtractor() {
        return new PatternConfigValueExtractor();
    }

    default public <A, B> ConfigValueExtractor<Either<A, B>> eitherExtractor(ConfigValueExtractor<A> left, ConfigValueExtractor<B> right) {
        return new EitherConfigExtractor<A, B>(left, right);
    }

    default public ConfigValueExtractor<UUID> uuidConfigValueExtractor() {
        return new UUIDConfigValueExtractor();
    }

    default public ConfigValueExtractor<double[]> doubleArrayConfigValueExtractor(ConfigValueExtractor<Double> doubleExtractor) {
        return new DoubleArrayConfigValueExtractor(doubleExtractor);
    }

    default public ConfigValueExtractor<Size> sizeConfigValueExtractor() {
        return new SizeConfigValueExtractor();
    }

    @DefaultComponent
    default public ConfigValueExtractor<LocalDate> localDateConfigValueExtractor() {
        return new LocalDateConfigValueExtractor();
    }

    @DefaultComponent
    default public ConfigValueExtractor<LocalTime> localTimeConfigValueExtractor() {
        return new LocalTimeConfigValueExtractor();
    }

    @DefaultComponent
    default public ConfigValueExtractor<LocalDateTime> localDateTimeConfigValueExtractor() {
        return new LocalDateTimeConfigValueExtractor();
    }

    @DefaultComponent
    default public ConfigValueExtractor<OffsetTime> offsetTimeConfigValueExtractor() {
        return new OffsetTimeConfigValueExtractor();
    }

    @DefaultComponent
    default public ConfigValueExtractor<OffsetDateTime> offsetDateTimeConfigValueExtractor() {
        return new OffsetDateTimeConfigValueExtractor();
    }
}

