/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import java.util.LinkedHashMap;
import java.util.Map;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public final class MapConfigValueExtractor<T>
implements ConfigValueExtractor<Map<String, T>> {
    private final ConfigValueExtractor<T> mapValueExtractor;

    public MapConfigValueExtractor(ConfigValueExtractor<T> mapValueExtractor) {
        this.mapValueExtractor = mapValueExtractor;
    }

    @Override
    public Map<String, T> extract(ConfigValue<?> value) {
        if (value instanceof ConfigValue.ObjectValue) {
            ConfigValue.ObjectValue objectValue = (ConfigValue.ObjectValue)value;
            LinkedHashMap<String, T> result = new LinkedHashMap<String, T>(objectValue.value().size());
            for (Map.Entry<String, ConfigValue<?>> entry : objectValue) {
                result.put(entry.getKey(), this.mapValueExtractor.extract(entry.getValue()));
            }
            return result;
        }
        throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValue.ObjectValue.class);
    }
}

