/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import java.time.DateTimeException;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigImplUtil;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public class PeriodConfigValueExtractor
implements ConfigValueExtractor<Period> {
    @Override
    public Period extract(ConfigValue<?> value) {
        if (value instanceof ConfigValue.NumberValue) {
            ConfigValue.NumberValue number = (ConfigValue.NumberValue)value;
            return Period.ofDays(number.value().intValue());
        }
        if (!(value instanceof ConfigValue.StringValue)) {
            throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValue.StringValue.class);
        }
        ConfigValue.StringValue str = (ConfigValue.StringValue)value;
        try {
            return PeriodConfigValueExtractor.parsePeriod(str);
        }
        catch (Exception e) {
            throw ConfigValueExtractionException.parsingError(value, e);
        }
    }

    public static Period parsePeriod(ConfigValue<String> configValue) {
        String s = ConfigImplUtil.unicodeTrim(configValue.value());
        String originalUnitString = PeriodConfigValueExtractor.getUnits(s);
        Object unitString = originalUnitString;
        String numberString = ConfigImplUtil.unicodeTrim(s.substring(0, s.length() - ((String)unitString).length()));
        if (numberString.isEmpty()) {
            throw new ConfigValueExtractionException(configValue.origin().config(), "No number in period value " + String.valueOf(configValue.origin().path()), null);
        }
        if (((String)unitString).length() > 2 && !((String)unitString).endsWith("s")) {
            unitString = (String)unitString + "s";
        }
        ChronoUnit units = switch (unitString) {
            case "", "d", "days" -> ChronoUnit.DAYS;
            case "w", "weeks" -> ChronoUnit.WEEKS;
            case "m", "mo", "months" -> ChronoUnit.MONTHS;
            case "y", "years" -> ChronoUnit.YEARS;
            default -> throw new ConfigValueExtractionException(configValue.origin().config(), "Could not parse time unit '%s' (try d, w, mo, y) in %s".formatted(originalUnitString, configValue.origin().path()), null);
        };
        try {
            return PeriodConfigValueExtractor.periodOf(Integer.parseInt(numberString), units);
        }
        catch (NumberFormatException e) {
            throw new ConfigValueExtractionException(configValue.origin().config(), "Could not parse period number %s in %s".formatted(numberString, configValue.origin().path()), null);
        }
    }

    private static Period periodOf(int n, ChronoUnit unit) {
        if (unit.isTimeBased()) {
            throw new DateTimeException(String.valueOf(unit) + " cannot be converted to a java.time.Period");
        }
        return switch (unit) {
            case ChronoUnit.DAYS -> Period.ofDays(n);
            case ChronoUnit.WEEKS -> Period.ofWeeks(n);
            case ChronoUnit.MONTHS -> Period.ofMonths(n);
            case ChronoUnit.YEARS -> Period.ofYears(n);
            default -> throw new DateTimeException(String.valueOf(unit) + " cannot be converted to a java.time.Period");
        };
    }

    private static String getUnits(String s) {
        char c;
        int i;
        for (i = s.length() - 1; i >= 0 && Character.isLetter(c = s.charAt(i)); --i) {
        }
        return s.substring(i + 1);
    }
}

