/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import java.util.LinkedHashMap;
import java.util.Map;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public final class MapConfigKeyValueExtractor<K, V>
implements ConfigValueExtractor<Map<K, V>> {
    private final ConfigValueExtractor<K> mapKeyExtractor;
    private final ConfigValueExtractor<V> mapValueExtractor;

    public MapConfigKeyValueExtractor(ConfigValueExtractor<K> mapKeyExtractor, ConfigValueExtractor<V> mapValueExtractor) {
        this.mapKeyExtractor = mapKeyExtractor;
        this.mapValueExtractor = mapValueExtractor;
    }

    @Override
    public Map<K, V> extract(ConfigValue<?> configValue) {
        if (configValue instanceof ConfigValue.ObjectValue) {
            ConfigValue.ObjectValue objectValue = (ConfigValue.ObjectValue)configValue;
            LinkedHashMap<K, V> result = new LinkedHashMap<K, V>(objectValue.value().size());
            for (Map.Entry<String, ConfigValue<?>> entry : objectValue) {
                K key = this.mapKeyExtractor.extract(new ConfigValue.StringValue(entry.getValue().origin(), entry.getKey()));
                V value = this.mapValueExtractor.extract(entry.getValue());
                result.put(key, value);
            }
            return result;
        }
        throw ConfigValueExtractionException.unexpectedValueType(configValue, ConfigValue.ObjectValue.class);
    }
}

