/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.factory;

import jakarta.annotation.Nullable;
import java.util.LinkedHashMap;
import java.util.Map;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.ConfigValuePath;
import ru.tinkoff.kora.config.common.impl.SimpleConfig;
import ru.tinkoff.kora.config.common.impl.SimpleConfigValueOrigin;
import ru.tinkoff.kora.config.common.origin.ConfigOrigin;
import ru.tinkoff.kora.config.common.origin.ContainerConfigOrigin;

public class MergeConfigFactory {
    public static Config merge(Config config, Config fallback) {
        ConfigValue.ObjectValue root1 = config.root();
        ConfigValue.ObjectValue root2 = fallback.root();
        ContainerConfigOrigin origin = new ContainerConfigOrigin(config.origin(), fallback.origin());
        ConfigValuePath path = ConfigValuePath.root();
        ConfigValue.ObjectValue newRoot = MergeConfigFactory.mergeObjects(origin, path, root1, root2);
        return new SimpleConfig(origin, newRoot);
    }

    @Nullable
    private static ConfigValue<?> merge(ConfigOrigin origin, ConfigValuePath path, @Nullable ConfigValue<?> value1, @Nullable ConfigValue<?> value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        if (value1 instanceof ConfigValue.ObjectValue) {
            ConfigValue.ObjectValue object1 = (ConfigValue.ObjectValue)value1;
            if (value2 instanceof ConfigValue.ObjectValue) {
                ConfigValue.ObjectValue object2 = (ConfigValue.ObjectValue)value2;
                return MergeConfigFactory.mergeObjects(origin, path, object1, object2);
            }
        }
        return value1;
    }

    private static ConfigValue.ObjectValue mergeObjects(ConfigOrigin origin, ConfigValuePath path, ConfigValue.ObjectValue object1, ConfigValue.ObjectValue object2) {
        LinkedHashMap newValues = new LinkedHashMap(object1.value().size());
        for (Map.Entry<String, ConfigValue<?>> entry1 : object1) {
            String key = entry1.getKey();
            ConfigValue<?> value1 = entry1.getValue();
            ConfigValue<?> value2 = object2.get(key);
            if (value2 == null) {
                if (value1 == null) continue;
                newValues.put(key, value1);
                continue;
            }
            if (value1 == null) {
                newValues.put(key, value2);
                continue;
            }
            ConfigValue<?> newObject = MergeConfigFactory.merge(origin, path.child(key), value1, value2);
            if (newObject == null) continue;
            newValues.put(key, newObject);
        }
        for (Map.Entry<String, ConfigValue<?>> entry : object2) {
            if (object1.value().containsKey(entry.getKey()) || entry.getValue() == null) continue;
            newValues.put(entry.getKey(), entry.getValue());
        }
        return new ConfigValue.ObjectValue(new SimpleConfigValueOrigin(origin, path), newValues);
    }
}

