/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.extractor;

import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.extractor.ConfigImplUtil;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public class DurationConfigValueExtractor
implements ConfigValueExtractor<Duration> {
    @Override
    @Nullable
    public Duration extract(ConfigValue<?> value) {
        return DurationConfigValueExtractor.extractFromValue(value);
    }

    public static Duration extractFromValue(ConfigValue<?> value) {
        if (value instanceof ConfigValue.NullValue) {
            ConfigValue.NullValue nv = (ConfigValue.NullValue)value;
            return null;
        }
        if (value instanceof ConfigValue.NumberValue) {
            ConfigValue.NumberValue number = (ConfigValue.NumberValue)value;
            return Duration.ofMillis(number.value().longValue());
        }
        if (!(value instanceof ConfigValue.StringValue)) {
            throw ConfigValueExtractionException.unexpectedValueType(value, ConfigValue.StringValue.class);
        }
        ConfigValue.StringValue str = (ConfigValue.StringValue)value;
        try {
            long nanos = DurationConfigValueExtractor.parseDuration(str);
            return Duration.ofNanos(nanos);
        }
        catch (Exception e) {
            throw ConfigValueExtractionException.parsingError(value, e);
        }
    }

    public static long parseDuration(ConfigValue<String> configValue) {
        String s = ConfigImplUtil.unicodeTrim(configValue.value());
        String originalUnitString = DurationConfigValueExtractor.getUnits(s);
        Object unitString = originalUnitString;
        String numberString = ConfigImplUtil.unicodeTrim(s.substring(0, s.length() - ((String)unitString).length()));
        if (numberString.length() == 0) {
            throw new ConfigValueExtractionException(configValue.origin().config(), "No number in duration value " + configValue.origin().path(), null);
        }
        if (((String)unitString).length() > 2 && !((String)unitString).endsWith("s")) {
            unitString = (String)unitString + "s";
        }
        TimeUnit units = switch (unitString) {
            case "", "ms", "millis", "milliseconds" -> TimeUnit.MILLISECONDS;
            case "us", "micros", "microseconds" -> TimeUnit.MICROSECONDS;
            case "ns", "nanos", "nanoseconds" -> TimeUnit.NANOSECONDS;
            case "d", "days" -> TimeUnit.DAYS;
            case "h", "hours" -> TimeUnit.HOURS;
            case "s", "seconds" -> TimeUnit.SECONDS;
            case "m", "minutes" -> TimeUnit.MINUTES;
            default -> throw new ConfigValueExtractionException(configValue.origin().config(), "Could not parse time unit '%s' (try ns, us, ms, s, m, h, d) in %s".formatted(originalUnitString, configValue.origin().path()), null);
        };
        try {
            if (numberString.matches("[+-]?[0-9]+")) {
                return units.toNanos(Long.parseLong(numberString));
            }
            long nanosInUnit = units.toNanos(1L);
            return (long)(Double.parseDouble(numberString) * (double)nanosInUnit);
        }
        catch (NumberFormatException e) {
            throw new ConfigValueExtractionException(configValue.origin().config(), "Could not parse duration number %s in %s".formatted(numberString, configValue.origin().path()), null);
        }
    }

    private static String getUnits(String s) {
        char c;
        int i;
        for (i = s.length() - 1; i >= 0 && Character.isLetter(c = s.charAt(i)); --i) {
        }
        return s.substring(i + 1);
    }
}

