/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.common.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.ConfigValuePath;
import ru.tinkoff.kora.config.common.PathElement;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException;
import ru.tinkoff.kora.config.common.impl.SimpleConfig;
import ru.tinkoff.kora.config.common.impl.SimpleConfigValueOrigin;
import ru.tinkoff.kora.config.common.origin.ConfigOrigin;
import ru.tinkoff.kora.config.common.origin.SimpleConfigOrigin;

public class MapConfigFactory {
    public static Config fromMap(Map<String, ?> map) {
        return MapConfigFactory.fromMap("Map@" + System.identityHashCode(map), map);
    }

    public static Config fromMap(String description, Map<String, ?> map) {
        SimpleConfigOrigin origin = new SimpleConfigOrigin(description);
        return MapConfigFactory.fromMap(origin, map);
    }

    public static Config fromMap(ConfigOrigin origin, Map<String, ?> map) {
        ConfigValuePath path = ConfigValuePath.root();
        ConfigValue.ObjectValue value = MapConfigFactory.toObject(origin, map, path);
        return new SimpleConfig(origin, value);
    }

    public static Config fromProperties(Properties properties) {
        return MapConfigFactory.fromProperties("Properties@" + System.identityHashCode(properties), properties);
    }

    public static Config fromProperties(String description, Properties properties) {
        SimpleConfigOrigin origin = new SimpleConfigOrigin(description);
        return MapConfigFactory.fromProperties(origin, properties);
    }

    public static Config fromProperties(ConfigOrigin origin, Properties properties) {
        LinkedHashMap map = new LinkedHashMap();
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            LinkedList<PathElement> _parts = new LinkedList<PathElement>();
            for (ConfigValuePath path = ConfigValuePath.parse(key); path != null && path.last() != null; path = path.prev()) {
                _parts.addFirst(path.last());
            }
            ArrayList parts = new ArrayList(_parts);
            Cloneable currentObject = map;
            for (int i = 0; i < parts.size(); ++i) {
                Map object;
                Object currentValue;
                PathElement element = (PathElement)parts.get(i);
                if (element instanceof PathElement.Index) {
                    PathElement.Index index = (PathElement.Index)element;
                    List list = (List)((Object)currentObject);
                    for (int j = 0; j <= index.index() + 1; ++j) {
                        if (list.size() >= j) continue;
                        list.add(null);
                    }
                    if (list.size() < index.index() || list.get(index.index()) == null) {
                        if (i + 1 < parts.size()) {
                            PathElement next = (PathElement)parts.get(i + 1);
                            if (next instanceof PathElement.Index) {
                                currentObject = new ArrayList();
                                list.set(index.index(), currentObject);
                                continue;
                            }
                            currentObject = new LinkedHashMap();
                            list.set(index.index(), currentObject);
                            continue;
                        }
                        list.set(index.index(), value);
                        continue;
                    }
                    Object item = list.get(index.index());
                    if (i + 1 < parts.size()) {
                        currentObject = item;
                        continue;
                    }
                    list.set(index.index(), value);
                    continue;
                }
                PathElement.Key field = (PathElement.Key)element;
                if (!(currentObject instanceof Map)) {
                    PathElement.Index index;
                    PathElement.Key k;
                    LinkedHashMap prev = map;
                    for (int j = 0; j < i - 1; ++j) {
                        Object e = parts.get(j);
                        if (e instanceof PathElement.Key) {
                            k = (PathElement.Key)e;
                            prev = ((Map)prev).get(k.name());
                            continue;
                        }
                        e = parts.get(j);
                        if (e instanceof PathElement.Index) {
                            index = (PathElement.Index)e;
                            prev = ((List)((Object)prev)).get(index.index());
                            continue;
                        }
                        throw new IllegalStateException();
                    }
                    PathElement prevPath = (PathElement)parts.get(i - 1);
                    currentObject = new LinkedHashMap();
                    if (prevPath instanceof PathElement.Key) {
                        k = (PathElement.Key)prevPath;
                        ((Map)prev).put(k.name(), currentObject);
                    } else if (prevPath instanceof PathElement.Index) {
                        index = (PathElement.Index)prevPath;
                        ((List)((Object)prev)).set(index.index(), currentObject);
                    } else {
                        throw new IllegalStateException();
                    }
                }
                if ((currentValue = (object = (Map)((Object)currentObject)).get(field.name())) == null) {
                    if (i + 1 < parts.size()) {
                        PathElement next = (PathElement)parts.get(i + 1);
                        if (next instanceof PathElement.Index) {
                            currentObject = new ArrayList();
                            object.put(field.name(), currentObject);
                            continue;
                        }
                        currentObject = new LinkedHashMap();
                        object.put(field.name(), currentObject);
                        continue;
                    }
                    object.put(field.name(), value);
                    continue;
                }
                if (i + 1 < parts.size()) {
                    currentObject = currentValue;
                    continue;
                }
                if (currentValue instanceof Map) continue;
                object.put(field.name(), value);
            }
        }
        return MapConfigFactory.fromMap(origin, map);
    }

    private static ConfigValue<?> toValue(ConfigOrigin origin, Object object, ConfigValuePath path) {
        if (object instanceof ConfigValue) {
            ConfigValue configValue = (ConfigValue)object;
            return configValue;
        }
        if (object instanceof Config) {
            Config configValue = (Config)object;
            return configValue.root();
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return MapConfigFactory.toObject(origin, map, path);
        }
        if (object instanceof List) {
            List list = (List)object;
            return MapConfigFactory.toList(origin, list, path);
        }
        SimpleConfigValueOrigin valueOrigin = new SimpleConfigValueOrigin(origin, path);
        if (object instanceof Number) {
            Number number = (Number)object;
            return new ConfigValue.NumberValue(valueOrigin, number);
        }
        if (object instanceof String) {
            String string = (String)object;
            return new ConfigValue.StringValue(valueOrigin, string);
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return new ConfigValue.BooleanValue(valueOrigin, bool);
        }
        if (object instanceof Enum) {
            Enum e = (Enum)object;
            return new ConfigValue.StringValue(valueOrigin, e.name());
        }
        throw new ConfigValueExtractionException(origin, "Unexpected object type with path %s: %s. Supported types are Map<String, ?>, List<?>, String, Number, Boolean and Enum<?>".formatted(path, object.getClass()), null);
    }

    private static ConfigValue.ObjectValue toObject(ConfigOrigin origin, Map<String, ?> object, ConfigValuePath path) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<String, ?> entry : object.entrySet()) {
            if (entry.getValue() == null) continue;
            result.put(entry.getKey(), MapConfigFactory.toValue(origin, entry.getValue(), path.child(entry.getKey())));
        }
        return new ConfigValue.ObjectValue(new SimpleConfigValueOrigin(origin, path), result);
    }

    private static ConfigValue.ArrayValue toList(ConfigOrigin origin, List<?> list, ConfigValuePath path) {
        ArrayList result = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object configValue = list.get(i);
            if (configValue == null) {
                result.add(null);
                continue;
            }
            result.add(MapConfigFactory.toValue(origin, configValue, path.child(i)));
        }
        return new ConfigValue.ArrayValue(new SimpleConfigValueOrigin(origin, path), Collections.unmodifiableList(result));
    }
}

