/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.ConfigValueOrigin;
import ru.tinkoff.kora.config.common.ConfigValuePath;
import ru.tinkoff.kora.config.common.impl.SimpleConfig;
import ru.tinkoff.kora.config.common.impl.SimpleConfigValueOrigin;
import ru.tinkoff.kora.config.common.origin.ConfigOrigin;

public class HoconConfigFactory {
    public static ru.tinkoff.kora.config.common.Config fromHocon(ConfigOrigin origin, Config config) {
        ConfigObject object = config.root();
        ConfigValuePath path = ConfigValuePath.root();
        ConfigValue.ObjectValue value = HoconConfigFactory.toObject(origin, object, path);
        return new SimpleConfig(origin, value);
    }

    @Nullable
    private static ConfigValue<?> toValue(ConfigOrigin origin, com.typesafe.config.ConfigValue object, ConfigValuePath path) {
        try {
            return switch (object.valueType()) {
                default -> throw new IncompatibleClassChangeError();
                case ConfigValueType.OBJECT -> HoconConfigFactory.toObject(origin, (ConfigObject)object, path);
                case ConfigValueType.LIST -> HoconConfigFactory.toArray(origin, (ConfigList)object, path);
                case ConfigValueType.NUMBER -> new ConfigValue.NumberValue((ConfigValueOrigin)new SimpleConfigValueOrigin(origin, path), (Number)object.unwrapped());
                case ConfigValueType.BOOLEAN -> new ConfigValue.BooleanValue((ConfigValueOrigin)new SimpleConfigValueOrigin(origin, path), (Boolean)object.unwrapped());
                case ConfigValueType.NULL -> null;
                case ConfigValueType.STRING -> new ConfigValue.StringValue((ConfigValueOrigin)new SimpleConfigValueOrigin(origin, path), (String)object.unwrapped());
            };
        }
        catch (ConfigException.NotResolved notResolved) {
            return new ConfigValue.StringValue((ConfigValueOrigin)new SimpleConfigValueOrigin(origin, path), object.render(ConfigRenderOptions.concise().setJson(false)));
        }
    }

    private static ConfigValue.ObjectValue toObject(ConfigOrigin origin, ConfigObject object, ConfigValuePath path) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : object.entrySet()) {
            ConfigValue<?> value = HoconConfigFactory.toValue(origin, (com.typesafe.config.ConfigValue)entry.getValue(), path.child((String)entry.getKey()));
            if (value == null) continue;
            result.put((String)entry.getKey(), value);
        }
        return new ConfigValue.ObjectValue((ConfigValueOrigin)new SimpleConfigValueOrigin(origin, path), result);
    }

    private static ConfigValue.ArrayValue toArray(ConfigOrigin origin, ConfigList list, ConfigValuePath path) {
        ArrayList result = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            com.typesafe.config.ConfigValue configValue = (com.typesafe.config.ConfigValue)list.get(i);
            result.add(HoconConfigFactory.toValue(origin, configValue, path.child(i)));
        }
        return new ConfigValue.ArrayValue((ConfigValueOrigin)new SimpleConfigValueOrigin(origin, path), List.copyOf(result));
    }
}

