/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.engine.bpmn.configurator;

import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.CamundaEngineBpmnConfig;
import ru.tinkoff.kora.camunda.engine.bpmn.CamundaEngineDataSource;
import ru.tinkoff.kora.camunda.engine.bpmn.configurator.ProcessEngineConfigurator;
import ru.tinkoff.kora.common.util.TimeUtils;

public final class AdminUserProcessEngineConfigurator
implements ProcessEngineConfigurator {
    private static final Logger logger = LoggerFactory.getLogger(AdminUserProcessEngineConfigurator.class);
    private final CamundaEngineBpmnConfig.AdminConfig adminConfig;
    private final CamundaEngineDataSource camundaEngineDataSource;

    public AdminUserProcessEngineConfigurator(CamundaEngineBpmnConfig camundaEngineConfig, CamundaEngineDataSource camundaEngineDataSource) {
        this.adminConfig = camundaEngineConfig.admin();
        this.camundaEngineDataSource = camundaEngineDataSource;
    }

    @Override
    public void setup(ProcessEngine engine) {
        if (this.adminConfig != null) {
            logger.debug("Camunda Configurator Admin user creating...");
            long started = TimeUtils.started();
            IdentityService identityService = engine.getIdentityService();
            AuthorizationService authorizationService = engine.getAuthorizationService();
            this.camundaEngineDataSource.transactionManager().inNewTx(() -> {
                if (!this.userAlreadyExists(identityService, this.adminConfig.id())) {
                    this.createUser(identityService);
                    if (!this.adminGroupAlreadyExists(identityService)) {
                        this.createAdminGroup(identityService);
                    }
                    this.createAdminGroupAuthorizations(authorizationService);
                    identityService.createMembership(this.adminConfig.id(), "camunda-admin");
                    logger.info("Camunda Configurator Admin user created in {}", (Object)TimeUtils.tookForLogging((long)started));
                } else {
                    logger.debug("Camunda Configurator Admin user already exist");
                }
            });
        }
    }

    private boolean userAlreadyExists(IdentityService identityService, String userId) {
        return identityService.createUserQuery().userId(userId).singleResult() != null;
    }

    private boolean adminGroupAlreadyExists(IdentityService identityService) {
        return identityService.createGroupQuery().groupId("camunda-admin").count() > 0L;
    }

    private void createUser(IdentityService identityService) {
        User newUser = identityService.newUser(this.adminConfig.id());
        newUser.setPassword(this.adminConfig.password());
        newUser.setFirstName(this.adminConfig.firstname() == null ? this.adminConfig.id().toUpperCase() : this.adminConfig.firstname());
        newUser.setLastName(this.adminConfig.lastname() == null ? this.adminConfig.id().toUpperCase() : this.adminConfig.lastname());
        newUser.setEmail((String)(this.adminConfig.email() == null ? this.adminConfig.id() + "@localhost" : this.adminConfig.email()));
        identityService.saveUser(newUser);
    }

    private void createAdminGroup(IdentityService identityService) {
        Group camundaAdminGroup = identityService.newGroup("camunda-admin");
        camundaAdminGroup.setName("Camunda Administrators");
        camundaAdminGroup.setType("SYSTEM");
        identityService.saveGroup(camundaAdminGroup);
    }

    private void createAdminGroupAuthorizations(AuthorizationService authorizationService) {
        for (Resources resource : Resources.values()) {
            if (authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"camunda-admin"}).resourceType((Resource)resource).resourceId("*").count() != 0L) continue;
            AuthorizationEntity groupAuth = new AuthorizationEntity(1);
            groupAuth.setGroupId("camunda-admin");
            groupAuth.setResource((Resource)resource);
            groupAuth.setResourceId("*");
            groupAuth.addPermission((Permission)Permissions.ALL);
            authorizationService.saveAuthorization((Authorization)groupAuth);
        }
    }
}

