/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.engine.bpmn.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Supplier;
import javax.sql.DataSource;
import ru.tinkoff.kora.camunda.engine.bpmn.transaction.CamundaTransactionManager;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.database.jdbc.RuntimeSqlException;

public class JdbcCamundaTransactionManager
implements CamundaTransactionManager {
    private final Context.Key<Connection> camundaConnectionKey = new Context.Key<Connection>(){

        protected Connection copy(Connection object) {
            return object;
        }
    };
    private final DataSource dataSource;

    public JdbcCamundaTransactionManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public CamundaTransactionManager.TransactionConnection currentConnection() {
        return new CamundaTransactionManager.TransactionConnection(){

            @Override
            public void commit() throws RuntimeSqlException {
                try {
                    Context ctx = Context.current();
                    Connection connection = (Connection)ctx.get(JdbcCamundaTransactionManager.this.camundaConnectionKey);
                    if (connection != null) {
                        connection.commit();
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeSqlException(e);
                }
            }

            @Override
            public void rollback() throws RuntimeSqlException {
                try {
                    Context ctx = Context.current();
                    Connection connection = (Connection)ctx.get(JdbcCamundaTransactionManager.this.camundaConnectionKey);
                    if (connection != null) {
                        connection.rollback();
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeSqlException(e);
                }
            }
        };
    }

    @Override
    public <T> T inContinueTx(Supplier<T> supplier) {
        Context ctx = Context.current();
        Connection currentConnection = (Connection)ctx.get(this.camundaConnectionKey);
        if (currentConnection != null) {
            boolean isClosed;
            try {
                isClosed = currentConnection.isClosed();
            }
            catch (SQLException e) {
                isClosed = true;
            }
            if (!isClosed) {
                try {
                    return this.processSupplier(currentConnection, supplier);
                }
                catch (SQLException e) {
                    throw new RuntimeSqlException(e);
                }
            }
        }
        return this.inNewTx(supplier);
    }

    @Override
    public void inContinueTx(Runnable runnable) {
        this.inContinueTx(() -> {
            runnable.run();
            return null;
        });
    }

    @Override
    public <T> T inNewTx(Supplier<T> supplier) {
        Context ctx = Context.current();
        try {
            T t;
            block11: {
                Connection connection = (Connection)ctx.set(this.camundaConnectionKey, (Object)this.dataSource.getConnection());
                try {
                    t = this.processSupplier(connection, supplier);
                    if (connection == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeSqlException(e);
                    }
                }
                connection.close();
            }
            return t;
        }
        finally {
            ctx.remove(this.camundaConnectionKey);
        }
    }

    @Override
    public void inNewTx(Runnable runnable) {
        this.inNewTx(() -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T processSupplier(Connection connection, Supplier<T> supplier) throws SQLException {
        boolean isAutoCommit = connection.getAutoCommit();
        if (isAutoCommit) {
            connection.setAutoCommit(false);
        }
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            if (isAutoCommit && !connection.isClosed()) {
                connection.setAutoCommit(true);
            }
        }
    }
}

