/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.engine.bpmn;

import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.camunda.bpm.engine.ArtifactFactory;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.camunda.bpm.engine.impl.el.JuelExpressionManager;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.StrongUuidGenerator;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.impl.telemetry.dto.ApplicationServerImpl;
import org.camunda.bpm.impl.juel.jakarta.el.ELResolver;
import ru.tinkoff.kora.application.graph.All;
import ru.tinkoff.kora.camunda.engine.bpmn.CamundaBpmn;
import ru.tinkoff.kora.camunda.engine.bpmn.CamundaEngineBpmnConfig;
import ru.tinkoff.kora.camunda.engine.bpmn.CamundaEngineDataSource;
import ru.tinkoff.kora.camunda.engine.bpmn.CamundaVersion;
import ru.tinkoff.kora.camunda.engine.bpmn.JobExecutorReadinessProbe;
import ru.tinkoff.kora.camunda.engine.bpmn.KoraArtifactFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.KoraDelegate;
import ru.tinkoff.kora.camunda.engine.bpmn.KoraDelegateWrapperFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.KoraELResolver;
import ru.tinkoff.kora.camunda.engine.bpmn.KoraExpressionManager;
import ru.tinkoff.kora.camunda.engine.bpmn.KoraJobExecutor;
import ru.tinkoff.kora.camunda.engine.bpmn.KoraProcessEngine;
import ru.tinkoff.kora.camunda.engine.bpmn.KoraProcessEngineConfiguration;
import ru.tinkoff.kora.camunda.engine.bpmn.KoraProcessEngineParallelInitializer;
import ru.tinkoff.kora.camunda.engine.bpmn.KoraResolverFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.configurator.AdminUserProcessEngineConfigurator;
import ru.tinkoff.kora.camunda.engine.bpmn.configurator.DeploymentProcessEngineConfigurator;
import ru.tinkoff.kora.camunda.engine.bpmn.configurator.ProcessEngineConfigurator;
import ru.tinkoff.kora.camunda.engine.bpmn.configurator.SecondStageKoraProcessEngineConfigurator;
import ru.tinkoff.kora.camunda.engine.bpmn.telemetry.CamundaEngineBpmnLoggerFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.telemetry.CamundaEngineBpmnMetricsFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.telemetry.CamundaEngineBpmnTelemetry;
import ru.tinkoff.kora.camunda.engine.bpmn.telemetry.CamundaEngineBpmnTelemetryFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.telemetry.CamundaEngineBpmnTracerFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.telemetry.DefaultCamundaEngineBpmnLoggerFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.telemetry.DefaultCamundaEngineBpmnTelemetryFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.telemetry.KoraEngineTelemetryRegistry;
import ru.tinkoff.kora.camunda.engine.bpmn.transaction.CamundaTransactionManager;
import ru.tinkoff.kora.camunda.engine.bpmn.transaction.JdbcCamundaTransactionManager;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.common.annotation.Root;
import ru.tinkoff.kora.common.readiness.ReadinessProbe;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;

public interface CamundaEngineBpmnModule {
    default public CamundaEngineBpmnConfig camundaEngineBpmnConfig(Config config, ConfigValueExtractor<CamundaEngineBpmnConfig> extractor) {
        return (CamundaEngineBpmnConfig)extractor.extract(config.get("camunda.engine.bpmn"));
    }

    @Tag(value={CamundaBpmn.class})
    @DefaultComponent
    default public DataSource camundaDataSource(DataSource dataSource) {
        return dataSource;
    }

    @DefaultComponent
    default public CamundaEngineDataSource camundaKoraDataSource(final @Tag(value={CamundaBpmn.class}) DataSource dataSource) {
        return new CamundaEngineDataSource(){

            @Override
            public CamundaTransactionManager transactionManager() {
                return new JdbcCamundaTransactionManager(dataSource);
            }

            @Override
            public DataSource dataSource() {
                return dataSource;
            }
        };
    }

    @DefaultComponent
    default public IdGenerator camundaEngineBpmnIdGenerator() {
        return new StrongUuidGenerator();
    }

    @DefaultComponent
    default public TelemetryRegistry camundaEngineBpmnKoraTelemetryRegistry(@Nullable ApplicationServerImpl applicationServer) {
        return new KoraEngineTelemetryRegistry(applicationServer);
    }

    @DefaultComponent
    default public JobExecutor camundaEngineBpmnKoraJobExecutor(CamundaEngineBpmnConfig engineConfig) {
        return new KoraJobExecutor(engineConfig);
    }

    default public ReadinessProbe camundaEngineBpmnReadinessProbe(JobExecutor jobExecutor) {
        return new JobExecutorReadinessProbe(jobExecutor);
    }

    @DefaultComponent
    default public CamundaEngineBpmnLoggerFactory camundaEngineBpmnLoggerFactory() {
        return new DefaultCamundaEngineBpmnLoggerFactory();
    }

    @DefaultComponent
    default public CamundaEngineBpmnTelemetryFactory camundaEngineBpmnTelemetryFactory(@Nullable CamundaEngineBpmnLoggerFactory logger, @Nullable CamundaEngineBpmnMetricsFactory metrics, @Nullable CamundaEngineBpmnTracerFactory tracer) {
        return new DefaultCamundaEngineBpmnTelemetryFactory(logger, metrics, tracer);
    }

    @DefaultComponent
    default public KoraDelegateWrapperFactory koraJavaDelegateTelemetryWrapper(CamundaEngineBpmnTelemetryFactory telemetryFactory, CamundaEngineBpmnConfig camundaEngineBpmnConfig) {
        return delegate -> {
            CamundaEngineBpmnTelemetry telemetry = telemetryFactory.get(camundaEngineBpmnConfig.telemetry());
            return execution -> {
                Context current = Context.current();
                Context fork = current.fork();
                fork.inject();
                CamundaEngineBpmnTelemetry.CamundaEngineTelemetryContext telemetryContext = telemetry.get(delegate.getClass().getCanonicalName(), execution);
                try {
                    delegate.execute(execution);
                    telemetryContext.close();
                }
                catch (Exception e) {
                    telemetryContext.close(e);
                    throw e;
                }
                finally {
                    current.inject();
                }
            };
        };
    }

    @DefaultComponent
    default public ELResolver camundaEngineBpmnKoraELResolver(KoraDelegateWrapperFactory wrapperFactory, All<KoraDelegate> koraDelegates, All<JavaDelegate> javaDelegates) {
        return new KoraELResolver(wrapperFactory, (List<KoraDelegate>)koraDelegates, (List<JavaDelegate>)javaDelegates);
    }

    @DefaultComponent
    default public JuelExpressionManager camundaEngineBpmnKoraExpressionManager(ELResolver koraELResolver) {
        return new KoraExpressionManager(koraELResolver);
    }

    @DefaultComponent
    default public ArtifactFactory camundaEngineBpmnKoraArtifactFactory(KoraDelegateWrapperFactory wrapperFactory, All<KoraDelegate> koraDelegates, All<JavaDelegate> javaDelegates) {
        return new KoraArtifactFactory(wrapperFactory, (List<KoraDelegate>)koraDelegates, (List<JavaDelegate>)javaDelegates);
    }

    @DefaultComponent
    default public CamundaVersion camundaEngineBpmnPackageVersion() {
        return new CamundaVersion(Optional.ofNullable(ProcessEngine.class.getPackage().getImplementationVersion()).map(String::trim).orElse(null));
    }

    @DefaultComponent
    default public KoraResolverFactory camundaEngineBpmnKoraComponentResolverFactory(KoraDelegateWrapperFactory wrapperFactory, All<KoraDelegate> koraDelegates, All<JavaDelegate> javaDelegates) {
        return new KoraResolverFactory(wrapperFactory, (List<KoraDelegate>)koraDelegates, (List<JavaDelegate>)javaDelegates);
    }

    @DefaultComponent
    default public ProcessEngineConfiguration camundaEngineBpmnKoraProcessEngineConfiguration(JobExecutor jobExecutor, TelemetryRegistry telemetryRegistry, IdGenerator idGenerator, JuelExpressionManager koraExpressionManager, ArtifactFactory artifactFactory, All<ProcessEnginePlugin> plugins, CamundaEngineDataSource camundaEngineDataSource, CamundaEngineBpmnConfig camundaEngineBpmnConfig, KoraResolverFactory componentResolverFactory, CamundaVersion camundaVersion, @Nullable CamundaEngineBpmnMetricsFactory metricsFactory) {
        return new KoraProcessEngineConfiguration(jobExecutor, telemetryRegistry, idGenerator, koraExpressionManager, artifactFactory, (List<ProcessEnginePlugin>)plugins, camundaEngineDataSource, camundaEngineBpmnConfig, componentResolverFactory, camundaVersion, metricsFactory);
    }

    @Root
    @DefaultComponent
    default public KoraProcessEngine camundaEngineBpmnKoraProcessEngine(ProcessEngineConfiguration processEngineConfiguration, CamundaEngineBpmnConfig camundaEngineBpmnConfig, All<ProcessEngineConfigurator> camundaConfigurators) {
        return new KoraProcessEngine(processEngineConfiguration, camundaEngineBpmnConfig, (List<ProcessEngineConfigurator>)camundaConfigurators);
    }

    default public ProcessEngineConfigurator camundaEngineBpmnKoraAdminUserConfigurator(CamundaEngineBpmnConfig camundaEngineBpmnConfig, CamundaEngineDataSource camundaEngineDataSource) {
        return new AdminUserProcessEngineConfigurator(camundaEngineBpmnConfig, camundaEngineDataSource);
    }

    default public ProcessEngineConfigurator camundaEngineBpmnKoraResourceDeploymentConfigurator(CamundaEngineBpmnConfig camundaEngineBpmnConfig) {
        return new DeploymentProcessEngineConfigurator(camundaEngineBpmnConfig);
    }

    default public ProcessEngineConfigurator camundaEngineBpmnKoraProcessEngineTwoStageCamundaConfigurator(ProcessEngineConfiguration engineConfiguration, CamundaEngineBpmnConfig camundaEngineBpmnConfig, JobExecutor jobExecutor) {
        return new SecondStageKoraProcessEngineConfigurator(engineConfiguration, camundaEngineBpmnConfig, jobExecutor);
    }

    @Root
    default public KoraProcessEngineParallelInitializer camundaKoraProcessEngineParallelInitializer(ProcessEngine processEngine, CamundaEngineBpmnConfig camundaEngineBpmnConfig, ProcessEngineConfiguration processEngineConfiguration, All<ProcessEngineConfigurator> camundaConfigurators) {
        return new KoraProcessEngineParallelInitializer(processEngine, camundaEngineBpmnConfig, processEngineConfiguration, (List<ProcessEngineConfigurator>)camundaConfigurators);
    }

    default public RuntimeService camundaEngineBpmnRuntimeService(ProcessEngine processEngine) {
        return processEngine.getRuntimeService();
    }

    default public RepositoryService camundaEngineBpmnRepositoryService(ProcessEngine processEngine) {
        return processEngine.getRepositoryService();
    }

    default public ManagementService camundaEngineBpmnManagementService(ProcessEngine processEngine) {
        return processEngine.getManagementService();
    }

    default public AuthorizationService camundaEngineBpmnAuthorizationService(ProcessEngine processEngine) {
        return processEngine.getAuthorizationService();
    }

    default public DecisionService camundaEngineBpmnDecisionService(ProcessEngine processEngine) {
        return processEngine.getDecisionService();
    }

    default public ExternalTaskService camundaEngineBpmnExternalTaskService(ProcessEngine processEngine) {
        return processEngine.getExternalTaskService();
    }

    default public FilterService camundaEngineBpmnFilterService(ProcessEngine processEngine) {
        return processEngine.getFilterService();
    }

    default public FormService camundaEngineBpmnFormService(ProcessEngine processEngine) {
        return processEngine.getFormService();
    }

    default public TaskService camundaEngineBpmnTaskService(ProcessEngine processEngine) {
        return processEngine.getTaskService();
    }

    default public HistoryService camundaEngineBpmnHistoryService(ProcessEngine processEngine) {
        return processEngine.getHistoryService();
    }

    default public IdentityService camundaEngineBpmnIdentityService(ProcessEngine processEngine) {
        return processEngine.getIdentityService();
    }
}

