/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.engine.bpmn.configurator;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ibatis.session.Configuration;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.CamundaEngineBpmnConfig;
import ru.tinkoff.kora.camunda.engine.bpmn.KoraProcessEngine;
import ru.tinkoff.kora.camunda.engine.bpmn.KoraProcessEngineConfiguration;
import ru.tinkoff.kora.camunda.engine.bpmn.configurator.ProcessEngineConfigurator;
import ru.tinkoff.kora.common.util.TimeUtils;

public final class SecondStageKoraProcessEngineConfigurator
implements ProcessEngineConfigurator {
    private static final Logger logger = LoggerFactory.getLogger(KoraProcessEngine.class);
    private final ProcessEngineConfiguration engineConfiguration;
    private final CamundaEngineBpmnConfig engineConfig;
    private final JobExecutor jobExecutor;

    public SecondStageKoraProcessEngineConfigurator(ProcessEngineConfiguration engineConfiguration, CamundaEngineBpmnConfig engineConfig, JobExecutor jobExecutor) {
        this.engineConfiguration = engineConfiguration;
        this.engineConfig = engineConfig;
        this.jobExecutor = jobExecutor;
    }

    @Override
    public void setup(ProcessEngine engine) {
        ProcessEngineConfiguration processEngineConfiguration;
        if (this.engineConfig.parallelInitialization().enabled() && (processEngineConfiguration = this.engineConfiguration) instanceof KoraProcessEngineConfiguration) {
            KoraProcessEngineConfiguration kEngine = (KoraProcessEngineConfiguration)processEngineConfiguration;
            logger.debug("Camunda BPMN Engine starting second stage...");
            long started = TimeUtils.started();
            Configuration src = kEngine.createConfigurationStageTwo();
            Configuration dest = kEngine.getSqlSessionFactory().getConfiguration();
            AtomicInteger statements = new AtomicInteger(0);
            src.getMappedStatements().forEach(ms -> {
                if (!dest.hasStatement(ms.getId(), this.engineConfig.parallelInitialization().validateIncompleteStatements())) {
                    dest.addMappedStatement(ms);
                    statements.incrementAndGet();
                }
            });
            if (this.jobExecutor.isAutoActivate()) {
                this.jobExecutor.start();
            }
            logger.info("Camunda BPMN Engine started second stage with {} new and total {} mapped statements in {}", new Object[]{statements.get(), dest.getMappedStatements().size(), TimeUtils.tookForLogging((long)started)});
        }
    }
}

