/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.camunda.engine.bpmn.transaction;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.camunda.bpm.engine.impl.cfg.TransactionContext;
import org.camunda.bpm.engine.impl.cfg.TransactionListener;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.camunda.engine.bpmn.transaction.CamundaTransactionManager;

public final class KoraTransactionContext
implements TransactionContext {
    private static final Logger logger = LoggerFactory.getLogger(KoraTransactionContext.class);
    private final CommandContext commandContext;
    private final CamundaTransactionManager transactionManager;
    private final List<TransactionListener> beforeCommit = new CopyOnWriteArrayList<TransactionListener>();
    private final List<TransactionListener> afterCommit = new CopyOnWriteArrayList<TransactionListener>();
    private final List<TransactionListener> beforeRollback = new CopyOnWriteArrayList<TransactionListener>();
    private final List<TransactionListener> afterRollback = new CopyOnWriteArrayList<TransactionListener>();
    private volatile TransactionState lastTransactionState = null;

    public KoraTransactionContext(CommandContext commandContext, CamundaTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.commandContext = commandContext;
    }

    public void commit() {
        this.lastTransactionState = TransactionState.COMMITTING;
        for (TransactionListener listener : this.beforeCommit) {
            try {
                listener.execute(this.commandContext);
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        }
        CamundaTransactionManager.TransactionConnection connection = this.transactionManager.currentConnection();
        connection.commit();
        this.lastTransactionState = TransactionState.COMMITTED;
        for (TransactionListener listener : this.afterCommit) {
            try {
                listener.execute(this.commandContext);
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        }
    }

    public void rollback() {
        this.lastTransactionState = TransactionState.ROLLINGBACK;
        for (TransactionListener listener : this.beforeRollback) {
            try {
                listener.execute(this.commandContext);
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        }
        CamundaTransactionManager.TransactionConnection connection = this.transactionManager.currentConnection();
        connection.rollback();
        this.lastTransactionState = TransactionState.ROLLED_BACK;
        for (TransactionListener listener : this.afterRollback) {
            try {
                listener.execute(this.commandContext);
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        }
    }

    public void addTransactionListener(TransactionState transactionState, TransactionListener transactionListener) {
        switch (transactionState) {
            case COMMITTING: {
                this.beforeCommit.add(transactionListener);
                break;
            }
            case COMMITTED: {
                this.afterCommit.add(transactionListener);
                break;
            }
            case ROLLINGBACK: {
                this.beforeRollback.add(transactionListener);
                break;
            }
            case ROLLED_BACK: {
                this.afterRollback.add(transactionListener);
            }
        }
    }

    public boolean isTransactionActive() {
        return this.lastTransactionState != null && this.lastTransactionState != TransactionState.ROLLINGBACK && this.lastTransactionState != TransactionState.ROLLED_BACK;
    }
}

